/* 	$Id: lcore.c,v 1.1.1.1 2000/05/07 20:26:14 mauhuur Exp $  */
/*
 *
 * $Log: lcore.c,v $
 * Revision 1.1.1.1  2000/05/07 20:26:14  mauhuur
 * Initial import
 *
 *
 *
 * */

char IL_Version[] = "4.0"; 

#ifndef lint
/* Commented until not actually used */
/*
static char 
   vcid[] = "$Id: lcore.c,v 1.1.1.1 2000/05/07 20:26:14 mauhuur Exp $";
*/
#endif /* lint */

/* Uncomment for Garbage Collector debugging */
/* NOTE: it's obsolete */
/* #define GC_DEBUG */
/* #define HI_DEBUG */
/* #define EV_DEBUG */

/* Uncomment to enable Lists per Second benchmark [obsolete] */
/* #define BENCHMARK */


#ifndef WINDOWS
#include "../sysdeps.h" /* Autoconf generated */
#else
/* note: may be out of date, I did not tested it for a long time */
#include "../WIN/sysdeps.h" /* Guessed by VSL */
#endif

/*--X VNAME: "Header" DESC: "VSLisp core version information" */
char *Header="VSLisp V4.0 Library (MAY-2000) ";
char *T_OS=OS;
char *T_CPU=CPU;

/* for GTK+ library et al., to pass main() arguments */
#ifndef NOGLOBALS
int GLBargc;
char **GLBargv;
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include "l_defs.h"
#include "../sysdeps.h"

#ifdef HAVE_SIGNALS
#include <signal.h>
#endif

unsigned int MEMa;

/*
   low bit: 0 --- atom;
            1 --- list;
   bits 1--7:
  ATOM:         1: HASH-TAB; 2: FILE; 3: TREE 4: DOUBLE; 5: INF. INT. 6: LONG; 
                7: ARRAY; 8: INF. FLOAT; 9: SPEC (ATOM WITH DESTRUCTOR)
		10: NAMED TYPE (for STRICT mode only)
  LIST:         10: NAMED TYPE
                 1: A-LIST
		 2: P-LIST
		 3: I-LIST
		 4: MISC-LIST
*/


/*--X FNAME: "mkatm" DESC: "Returns a new ATOM contains string of l bytes" */
ATOM mkatm(int l)
{
  ATOM tmp;
  tmp=(ATOM)l_alloc_l();
  if(l>0) tmp->a=(char *)l_alloc_a((usi)l);
  tmp->g=1;tmp->f=0; tmp->b=NULL; 
  return tmp;
}

/*--X FNAME: "mklist" DESC: "Returns a new list with head p1 and tail p2" */
LIST mklist(LIST p1,LIST p2)
{
  LIST tmp;
  tmp=(LIST)l_alloc_l();
  tmp->f=1;
  tmp->h.l=p1;tmp->t.l=p2;
  tmp->g=1;
  return tmp;
}

/*--X VNAME: "lOf" DESC: "default output file" */
FILE *lOf;

/*--X FNAME: "lText" DESC: "Convert atom to a readable text string" */
char *lText(ATOM a,char *TeXt)
{
  char f;
  if(a==NIL) {sprintf(TeXt,"NIL");return TeXt;}
  if(a->a==NIL) {sprintf(TeXt,"NIL");return TeXt;}
  f=a->f>>1;
  switch(f) {
  case 0: return a->a;
  case 1: sprintf(TeXt,"[^H]");return TeXt;
  case 2: sprintf(TeXt,"[^F]");return TeXt;
  case 3: sprintf(TeXt,"[^T]");return TeXt;
  case 4: sprintf(TeXt,"%g",*(double*)(a->a)); return TeXt;
  case 6: sprintf(TeXt,"%d",*(int*)(a->a)); return TeXt;
  case 5: sprintf(TeXt,"[^II]");return TeXt;
  case 8: sprintf(TeXt,"[^IF]");return TeXt;
  case 7: sprintf(TeXt,"[^AR]");return TeXt;
  case 9: sprintf(TeXt,"[^SPEC]");return TeXt;
  }
  return TeXt;
}

/*--X FNAME: "printll" DESC: "Print a list without main paranthes" */
int printll(LIST l)
{
  char TeXt[300];

  if(l==NIL) {fprintf(lOf," NIL");return 0;}
  if(!Typof(l)) {
    fprintf(lOf," %s",lText((ATOM)l,TeXt));
    return 0;
  }
  
#ifdef HI_DEBUG
  fprintf(lOf,"%c[7m*%d*%c[0m",27,l->g,27);
#endif
  if(l->h.l!=NIL) {
    if(Typof(l->h.l)==1) {
      fprintf(lOf," (");printll(l->h.l);fprintf(lOf,")");
    }
    if(Typof(l->h.l)==0) printll(l->h.l);
  } else fprintf(lOf," NIL");
  
  if(l->t.l!=NIL) {
    if(Typof(l->t.l)==0) {
      fprintf(lOf," . %s",lText(l->t.a,TeXt));
      return 0;
    } else
      printll(l->t.l);
  } return 1;
}

/*--X FNAME: "printl" DESC: "print a list" */
int printl(LIST a)
{
  fprintf(lOf,"(");printll(a);fprintf(lOf,")"); return 0;
}

/*--X FNAME: "MakeAtom" DESC: "returns atom containing a copy of string s" */
ATOM MakeAtom(char *s)
{
  ATOM tmp;
  if(s==NULL) return MakeAtom("NIL");
  tmp=(ATOM)l_alloc_l();
  tmp->a=(char *)l_alloc_a((usi)(strlen(s)+1));
  strcpy(tmp->a,s);
  tmp->g=1;tmp->f=0;tmp->b=NULL;
  return tmp;
}

/*--X FNAME: "MakeDAtom" DESC: "returns atom containing double d" */
ATOM MakeDAtom(double d)
{
  ATOM tmp;
  double *dd;
  tmp=(ATOM)l_alloc_l();
  tmp->a=(char *)malloc(sizeof(double));
  dd=(double *)(tmp->a);
  (*dd)=d;
  tmp->g=1;tmp->f=4<<1;tmp->b=NULL;
  return tmp;
}

/*--X FNAME: "MakeFAtom" DESC: "Returns atom containing file descriptor" */
ATOM MakeFAtom(FILE *d)
{
  ATOM tmp;
  tmp=(ATOM)l_alloc_l();tmp->f=0;
  tmp->a=(char *)d;
  tmp->g=100;tmp->f=2<<1;tmp->b=NULL;
  return tmp;
}

/*--X FNAME: "GetDouble" DESC: "Takes a double from atom a" */
double GetDbleOld(ATOM a)
{
  double *dd;
  dd=(double*)(a->a);
  return *dd;
}

/*--X VNAME: "Pos" DESC: "Temporary variable for a string to list conversion" */
int Pos;

/*--X FNAME: "isatom" DESC: "Check is it atom" */
int isatom(char *s,int p)
{
  /* Stupid function, eh? 
     I must not drink so much :(
   */
  if(s[p]!='(' && s[p]!=')' && s[p]!=39 && s[p]!='!' && s[p]!='~' &&
     s[p]!='\n' && s[p]!='\t' && s[p]!=' ') return 1;
  return 0;
}

/*--X FNAME: "reada" DESC: "Read one atom from input character string" */
ATOM reada(char *s)
{
  char c[500];
  ATOM t;
  int i,fd,nd;
  fd=1;nd=0;
  
  for(i=0;s[Pos]!='\n' && s[Pos]!='\t' &&
	s[Pos]!=' ' && s[Pos]!=')' && s[Pos]!='(' && s[Pos]!='!';++Pos,i++)
    {
      if(s[Pos]==34) {Pos++;fd=0;
      while(s[Pos]!=34) {c[i]=s[Pos];i++;Pos++;}
      Pos++;c[i]=0;break;
      }
      else {
	c[i]=s[Pos]; c[i+1]=0;
	if(!(isdigit(c[i]) || (c[i]=='+') || (c[i]=='-') || (c[i]=='.'))) {
	  if(i) {
	    if(!((c[i]=='e' || c[i]=='E') && (c[i-1]=='.' || isdigit(c[i-1])))) fd=0;
	  } else fd=0;
	}
	if(isdigit(c[i])) nd++;
      }
    }
  c[i]=0;
  if(nd==0) fd=0;
  if(!fd) {
    t=MakeAtom(c);
  } else
    {
      double *d;
      t=mkatm(sizeof(double));t->f=4<<1;
      d=(double*)(t->a);
      sscanf(c,"%lf",d);
    }
  return t;
}

int PosL,sLevel;

/*--X FNAME: "readl" DESC: "Make a list from input string" */
LIST readl(char *s)
{
  LIST t;
  int SV;
  t=NIL;

  while(s[Pos]==' ' || s[Pos]=='\n' || s[Pos]=='\t') ++Pos;
  if(s[Pos]=='!') {
    while(s[Pos]!='\n') ++Pos; t=readl(s);return t;
  }
  if(isatom(s,Pos)) {
    t=mklist((LIST)reada(s),NIL);t->t.l=readl(s);
    return t;
  }
  if(s[Pos]==')') {
    sLevel--; if(sLevel>0) ++Pos;  
    return t;
  }
  if(s[Pos]=='(') {
    ++Pos;sLevel++;
    if(PosL) {t=mklist(readl(s),NIL);t->t.l=readl(s);} else
      {
	PosL=1;
	t=readl(s);
      }
    return t;
  }
  if(s[Pos]==39 || s[Pos]=='~') {
    ++Pos;
    if(s[Pos]=='(')
      {
	SV=PosL;PosL=0;
	t=mklist(
		 mklist(
			(LIST)MakeAtom("quote"),
			mklist(
			       readl(s),
			       NIL)),
		 NIL);
	PosL=SV;
      }
    else
      t=mklist(
	       mklist(
		      (LIST)MakeAtom("quote"),
		      mklist(
			     (LIST)reada(s),
			     NIL)
		      ),
	       NIL);
    t->t.l=readl(s);
    return t;
  }
  return NIL;
}

/*--X VNAME: "rBuf" DESC: "temporary buffer for a reader" */
char rBuf[65000];

int nofp,rBp;

/*--X FNAME: "IReader" DESC: "Flush all reader stuff" */
int IReader() 
{
  nofp=0;rBp=0;PosL=0;sLevel=0;Pos=0;return 0;
}

/*--X FNAME: "LRead" DESC: "Read one list from file" */
LIST LRead(FILE *f) 
{
  LIST t;
  char c,tt,ct;
  IReader();
  do {
   tt=0;
   while(((c=fgetc(f))!='(') && !feof(f)) if(c=='!') {tt=1;break;}
   if(tt) while((c=fgetc(f))!='\n');
  } while(tt);
  ct=0;
  do { 
   if(feof(f)) return NIL;
   if(c=='!' && !ct) while(c!='\n') {c=fgetc(f);}
   rBuf[rBp]=c;rBp++; 
   if(c==34) ct=1-ct;
   if(!ct) {if(c=='(') nofp++; else if(c==')') nofp--;}
   c=fgetc(f);
  } while(nofp);
  Pos=0;rBuf[rBp]=0;
  t=readl(rBuf); Pos=0;
  return t;
}

/*--X FNAME: "LReadS" DESC: "Read one list from string" */
LIST LReadS(char *f) 
{
  LIST t;
  char c,tt,ct;
  ui nn;
  IReader();
  nn=0;
  do {tt=0;
  while(((c=f[nn++])!='(') && c) if(c=='!') {tt=1;break;}
  if(tt) while((c=f[nn++])!='\n' && c!=0);
  } while(tt);
  ct=0;
  do { 
    if(!c) return NIL;
    if(c=='!' && !ct) while(c!='\n' && c!=0) {c=f[nn++];}
    rBuf[rBp]=c;rBp++; 
    if(c==34) ct=1-ct;
    if(!ct) {if(c=='(') nofp++; else if(c==')') nofp--;}
    c=f[nn++];
  } while(nofp);
  Pos=0;rBuf[rBp]=0;
  t=readl(rBuf); Pos=0;
  t->g=1;
  return t;
}

/*--X FNAME: "physcopy" DESC: "creates a copy of list and all it's atoms.
  Note that it cannot work with other ATOM types then double and string" */
LIST physcopy(LIST a)
{
  if(a==NIL) return NIL;
  if(Typof(a)==0) {
    if(((a->f)>>1)==4)
      return (LIST)MakeDAtom(GetDouble((ATOM)a));
    else
      return (LIST)MakeAtom(((ATOM)a)->a);
  }
  return mklist(physcopy(a->h.l),physcopy(a->t.l));
}


/*--X FNAME: "aplist" DESC: "append b to a: (a b) + (a b) -> (a b (a b))" */
LIST aplist(LIST a,LIST b)
{
 LIST t;
 t=a;
 while(t->t.l!=NIL) t=t->t.l;
 t->t.l=mklist(b,NIL);
 return a;
}

/*--X FNAME: "aplist01" DESC: "Append b to a: (a b) +1 (a b) -> (a b a b)" */
LIST aplist01(LIST a,LIST b)
{
 LIST t;
 t=a;
 while(t->t.l!=NIL) t=t->t.l;
 t->t.l=b;
 return a;
}

/*--X FNAME: "kilatom" DESC: "kill atom if it's unlinked" */
int kilatom(ATOM a)
{
 int  *f(void *);
#ifdef GC_DEBUG
 char ttx[200];
#endif
 if(a==NIL) return 0;
 if((a->g)>0) {return 0;}
#ifdef GC_DEBUG
 fprintf(lOf,"KA::%d  %s (%x,%x)\n",a->f,lText(a,ttx),a,a->a);
#endif
 if(a->f==9<<1) {
  (((FD *)(a->b))->f)(a); /* CALL DESTRUCTION FUNCTION */
 } else
 if(a->a!=NIL) l_free(a->a); /* realloc(a->a,0);*/
 lp_free(a);
 return 1;
}

/*--X FNAME: "killlist" DESC: "kill list if it's unlinked" */
int killlist(LIST l)
{
 if(l==NIL) return 0;
 if((l->g)>0) return 0;
 if((l->f)&1) {
#ifdef GC_DEBUG
  printf("KL::%d ",l->f);printl(l);printf("\n");
#endif
  if(l->h.l!=NIL) {
   l->h.l->g--; killlist(l->h.l);
  }
  if(l->t.l!=NIL) {
   l->t.l->g--; killlist(l->t.l);
  }
  lp_free(l);
 } else kilatom((ATOM)l); return 0;
}

/*--X FNAME: "kilat" DESC: "do not call it, please!" */
int kilat(ATOM a)
{
  int  *f(void *);
  if(a==NIL) return 0;
  if(a->f==9<<1) {
    (((FD *)(a->b))->f)(a); /* CALL DESTRUCTION FUNCTION */
  } else
    if(a->a!=NIL) l_free(a->a);
  lp_free(a);
  return 1;
}


/*--X FNAME: "killl" DESC: "Do not call it" */
int killl(LIST l)
{
  if(Typof(l->h.l)==1 && l->h.l!=NIL)
    {killl(l->h.l);l->h.l=NIL;}
  if(Typof(l->t.l)==1 && l->t.l!=NIL)
    {killl(l->t.l);l->t.l=NIL;}
  if(Typof(l->h.l)==0 && l->h.a!=NIL) kilat(l->h.a);
  if(Typof(l->t.l)==0 && l->t.a!=NIL) kilat(l->t.a);
  lp_free(l); return 0;
}

/*--X FNAME: "killtop" DESC: "kill toplevel of list, only for lambda" */
int killtop(LIST l)
{
  if(l==NIL) return 0;
  if((l->g)!=0) return 0;
  if(l->t.l!=NIL && Typof(l->t.l)==1) {
    l->t.l->g--; killtop(l->t.l);
  }
  lp_free(l);
  return 1;
}

/*--X FNAME: "EqAtom" DESC: "Stupid function, do not call it" */
int EqAtom(ATOM a,char *s)
{
  return !strcmp(a->a,s);
}

LIST lT;
LIST lNIL;


FILE * FileS[25];


/* Unused */
Symbol *defRet();


FILE *FiI;
ui frFp;
ui frPos;
ui frSz;
char *frm;


uc etchar(FILE *f)
{
  if(!frFp) {frPos++;return frm[frPos-1];}
  return fgetc(f);
}


uc *qqs;
ui qqssz=32000;
ui spo;
uc qqc;

int feof1(FILE *f)
{
  if(frFp) {return feof(f);}
  return (frPos>=frSz);
}

#define SFN 1600

/* fdesc *SysFuns[SFN];
   int SFp;*/

int HSiz;

unsigned int NSM;

fdesc *mkfdesc()
{
 return (fdesc *)malloc(sizeof(fdesc));
}

fdesc find_f;

/* Obsolete */
int showhash(hash *h,int d,symtab *tab)
{
  int i;
  if(h==NIL) return 0;
  fprintf(lOf,"Hashtab %lx, depth %d\n",(long)h,d);
  for(i=0;i<256;i++) {
    if(h[i].c!=NOSYM) fprintf(lOf,"['%s']",tab->Symbols[h[i].c]->nm);
    else
      fprintf(lOf,"[...]");
  } fprintf(lOf,"\n");
  for(i=0;i<256;i++) showhash(h[i].h,d+1,tab); return 0;
}

/* Suxx! We do not need global contextes! */
symtab l_global_symtab;

ui findinhash(symtab *tab,char *n)
{
  return IL_find_in_hash(tab->t,0,n);
}

ui symbolp(uc *n,symtab *t,ui *csm,symtab **tt)
{
  ui csym;

  if(t->t) {
    csym=IL_find_in_hash(t->t,0,n);
  }
  else
    {
      ui i;
      csym=NOSYM;
      for(i=0;i<t->cnofsym;i++)
	  {if(!strcmp(t->Symbols[i]->nm,n)) {csym=i;break;}}
    }
  *csm=csym;
  if(csym!=NOSYM) 
    {
      *tt=t;return 1;
    }
  if(t->nxt!=NULL) 
    return symbolp(n,t->nxt,csm,tt); 
  else 
    return 0;
}

int heSz=0;
int hasInted=0;

int initglobtab(ui n)
{
  LISPcontext *c;
  InitMem(1024); /* Now does nothing */
  
  if(!hasInted){
    lT=(LIST)MakeAtom("T");lT->g=100;
    lNIL=(LIST)MakeAtom("NIL");lNIL->g=100;
    IL_init_hash();
    hasInted=1;
  }
 
  global.nofsym=n;
  global.Symbols=(Symbol **)lmalloc(sizeof(Symbol *)*n);
  global.cnofsym=0;
  global.t=IL_mkha();
  global.nxt=NULL;global.nxtp=NULL;
  global.context=malloc(sizeof(LISPcontext));
  c=global.context;
  c->Global= &global;
  c->SysFuns= (fdesc **)malloc(sizeof(fdesc *)*3000);
  c->sfhash=IL_mkha();
  c->noffuns=0;
  return 0;
}

symtab *CreateCTX(int n)
{
  symtab *tb;LISPcontext *c;
  if(!hasInted){
    /*  if(heSz) initha(heSz); else initha(15); */ /* INIT FUNKTIONS */
    IL_init_hash();
    lT=(LIST)MakeAtom("T");lT->g=100;
    lNIL=(LIST)MakeAtom("NIL");lNIL->g=100;
    hasInted=1;
  }
  
  tb=(symtab *)malloc(sizeof(symtab));
  tb->nofsym=n;
  tb->Symbols=(Symbol **)lmalloc(sizeof(Symbol *)*n);
  tb->cnofsym=0;
  tb->t=IL_mkha();
  tb->nxt=NULL;tb->nxtp=NULL;
  tb->context=malloc(sizeof(LISPcontext));
  ((LISPcontext *)(tb->context))->Global= tb;
  c=global.context;
  c->Global= &global;
  c->SysFuns= (fdesc **)malloc(sizeof(fdesc *)*3000);
  c->sfhash=IL_mkha();
  c->noffuns=0;
  return 0;
 
  return tb;
}

symtab *ReturnGlobal()
{
 return &global;
}
 
ui lengthl(LIST a)
{
  LIST t;
  ui i;
  t=a;
  for(i=0;t!=NIL;i++) t=t->t.l;
  return i;
}

 LIST  leval(LIST l,symtab *tab);
 LIST  onesymeval(LIST l,symtab *tab);

int aatl(Symbol *s)
{
  if(s->v.l==NIL) return 0;
  if((s->v.l->g)>0)  return 0;
  if(Typof(s->v.l)==1) {
    killlist(s->v.l); s->v.l=NIL;
  }  
  else
    {
      kilatom(s->v.a); s->v.a=NIL;
    } 
  return 0;
}

void AddSymbol(Symbol *s,symtab *tab)
{
  if(tab->t!=NULL) IL_put_in_hash(tab->t,0,s->nm,tab->cnofsym);
  tab->cnofsym++;
  /* TODO: There should be some test and realloc() */
}


int KillTabTail(symtab *tab)
{
 if(tab->nxtp!=NULL) {
  KillTabTail(tab->nxt);
  tab->nxtp->g--;aatl1(tab->nxtp);
  tab->nxt=NULL;tab->nxtp=NULL; /* UNLINK */
 } return 0;
}

#ifdef __inline__
__inline__
#endif
LIST lambda(LIST ld,LIST pars,symtab *tab)
{
 LIST fpa,bo,tmp,tmp1;
 symtab *lpars;
 Symbol *tt,*Uu;
 LIST Ret;
 LIST U,UU;
 ui nlpars,npars,i,FlG;

 fpa=ld->t.l->h.l; /* (cdar ld) */
 bo=ld->t.l->t.l;  /* (cddr ld) */
 FlG=0;

 lpars=(symtab *)malloc(sizeof(symtab));

 lpars->context=tab->context; /* CONTEXT HANDLING */

 /* Create table of local symbols (formal parameters) */
 if(fpa==NULL || fpa->f) nlpars=lengthl(fpa); 
	else 
	{nlpars=0;FlG=1;}
 npars=lengthl(pars);
 lpars->nofsym=nlpars+1;
 lpars->cnofsym=nlpars+1;
 lpars->Symbols=(Symbol **)malloc((nlpars+1)*sizeof(Symbol *));
 tmp=fpa;tmp1=pars;
 lpars->Symbols[0]=NULL;
 lpars->nxt=NULL;lpars->nxtp=NULL;
 UU=NULL;
 Uu=(Symbol *)malloc(sizeof(Symbol));
 strcpy(Uu->nm,"ParList");
 lpars->Symbols[nlpars]=Uu;Uu->v.l=NIL;
 
 if(npars) {
  for(i=0;tmp1!=NIL;i++) {
   tt=(Symbol *)malloc(sizeof(Symbol));
   if(((i<nlpars) && (tmp->h.a->a[0]=='&')) || ((i>=nlpars) && FlG))  {
    tt->v=tmp1->h;
    FlG=1;
   } else {
    tt->v.l=onesymeval(tmp1,tab);FlG=0;
   }
   if(i>0) {
     Uu->v.l->t.l=(LIST)mklist(tt->v.l,NIL);
     Uu->v.l=Uu->v.l->t.l;
   } else {
    Uu->v.l=(LIST)mklist(tt->v.l,NIL);
    if(i==0) {U=Uu->v.l; UU=U;}
   }
   if(tt->v.l!=NIL) tt->v.l->g++;
   if(i<nlpars) {
    lpars->Symbols[i]=tt;
    strcpy(lpars->Symbols[i]->nm,tmp->h.a->a+FlG);
    tmp=tmp->t.l;
   } else l_free((char *)tt);
   tmp1=tmp1->t.l;
  }
  Uu->v.l=UU;
  UU->g=1;

 }

 lpars->t=NULL;

 /* All that shit only for this small loop :( */
 Ret=NIL;
 while(bo) {
   aatl1(Ret);
   Ret=onesymeval(bo,lpars);
   bo=bo->t.l;
 }

 if(Ret) Ret->g+=2;
 for(i=0;i<nlpars;i++) if(lpars->Symbols[i]) {
  l_free(lpars->Symbols[i]);
 }
 l_free(lpars->Symbols[nlpars]);
 l_free(lpars->Symbols);
 KillTabTail(lpars);
 l_free((void *)lpars);
 if(UU) UU->g--;
 aatl1(UU);
 if(Ret) Ret->g-=2;
 return Ret;
}

int ERRR()
{
 printf("%%LSP-E-HLV, Lisp Error. Hasta la vista...\n\n");
 fprintf(lOf,"\n");
 exit(0);return 0;
}

LIST onesymeval(LIST l,symtab *tab)
{
  ui csym;
  symtab *glb;symtab *tb;
  LIST h;
  /* Is it right (to evaluate NIL as a NIL?) */
  if(!l) return l;
  h=l->h.l;
  if(!(h->f&1))
    {
      if((h->f)>>1==4) {
	return h;
      }
      if(symbolp(((ATOM)h)->a,tab,&csym,&tb)) {
	return tb->Symbols[csym]->v.l;
      } else {
	if(symbolp(((ATOM)h)->a,(glb=tab->context->Global),&csym,&tb)) {
	  return tb->Symbols[csym]->v.l;
	}
	else {
	  fprintf(stderr,"\nUndefined Symbol %s\n",((ATOM)h)->a); 
#ifdef UGLY_LISP
	  ERROR();
#endif
	  fprintf(stderr,"WARNING: UGLY_LISP was not defined, so,\n");
	  fprintf(stderr,"it will not halt here, it'll segfault later!!!\n");
	  return NIL;
	} 
      }
    } else return leval(h,tab);
}

int CompileP=1;

fdesc tfun;

ui lseks=0,sekond=0,llseks=0,sseknd;

void prllsek()
{
 printf("l/s: %d\n",llseks);
}

LIST  leval(LIST l,symtab *tab)
{
 LIST  Ret,lhl;
 ATOM lha;
 int fu;
 ui depth,dval;
 fdesc **SysFuns;
 LISPcontext *ctx;
 symtab *glb,*tb;

 ctx=tab->context;
 depth=0;SysFuns=ctx->SysFuns;

#ifdef EV_DEBUG
 fprintf(lOf,"EVAL PARAMETER IS: \n{");
 printl(l);
 fprintf(lOf,"}\n\n");
#endif

 lhl=l->h.l;
 lha=l->h.a;
 if(Typof(lhl)==1) {
  if(Typof(lhl->h.l)==0) {
   Ret=lambda(lhl,l->t.l,tab);
   return Ret;
  }
 } else
 {
  
  if(lha->b!=NULL)  {
   LISPHOOK fun;
   fun=(LISPHOOK)(lha->b);
   Ret=fun(tab,l);
   return Ret;
  }
  fu=IL_find_in_hash(ctx->sfhash,0,lha->a);
  if(fu!=NOSYM) {
   LIST tls;
   tls=l;
   /* COMPILE */
   if(CompileP) {
     lha->b=(char *)(SysFuns[fu]->f.f); /*
					   Dirty trick! We assume that
					   function and char * pointers
					   are the same....
					   Bugland & Co sucks here 
					*/
   }
   /*---------*/

   /*if(SysFuns[fu]->t==0)*/ return (*(SysFuns[fu]->f.f))(tab,tls);
  }
  glb=ctx->Global;
  if(symbolp(lha->a,glb,&dval,&tb)) { 
   Ret=lambda(tb->Symbols[dval]->v.l,l->t.l,tab);
   return Ret;
  }
  if(symbolp(l->h.a->a,tab,&dval,&tb)) {
   Ret=lambda(tb->Symbols[dval]->v.l,l->t.l,tab);
   return Ret;
  }

  if(lha->a[0]=='q') {
   if(!strcmp(lha->a,"quote")) {
    Ret=l->t.l->h.l;
    return Ret;
   }
  }


 }


 if(lha->a) {
  printf("\n[Undefined function %s]\n Error in list: ",l->h.a->a);
  printl(l);
  printf("\n");
#ifdef UGLY_LISP
  ERROR();
#endif
  return NIL;
 } else {printf("\nNIL????\n");return NIL;}
}

void deffun(symtab *tab,char *n,LIST (*f)(symtab *tab,LIST l))
{
  LISPcontext *c;
  fdesc **tt;fdesc *t;
  ui nm;
  c=tab->context;
  tt=c->SysFuns;
  nm=c->noffuns;
  t=mkfdesc();t->c=n;t->f.f=f;
  tt[nm]=t;c->noffuns++;
  IL_put_in_hash(c->sfhash,0,n,nm);
}

/* Context-modules support, 16-APR-1998 */
/* General idea (c) by S.Bityukov */

/*
LIST ContextLoad(symtab *tab,LIST l)
{
	uc modname[20];
	int fu;
	symtab *tt;
	hash *Func_save,*H0_Save;
	strcpy(modname,l->h.a->a);
	Func_save=Functions;
	H0_Save=H0;
	strcat(modname,"_t");
	tfun.c=modname;tfun.t=0;
	fu=puttoha(&tfun,0); 
	tt=SysFuns[fu]->f.t;
	Functions=tt->t;H0=tt->t;
	tfun.c=l->t.l->h.a->a;tfun.t=0;
	fu=puttoha(&tfun,0);
	Functions=Func_save;H0=H0_Save;
	return (*(SysFuns[fu]->f.f))(tab,l->t.l);
}
*/

/*
void ContextDEFFUN(	char *s1,
			char *s2,
			LIST (*f)(symtab *tab,LIST l))
{
 fdesc *t;
 t=mkfdesc();
 t->c=s1;t->f.f=&ContextLoad;t->t=0;
 puttoha(t,1);
  ...  DOPISAT' NADO BY... 
}
*/


/*

                       XPEHOBO, HE BE3ET B KAPTAX!!!
             YXO HE CPET, YXO BOCEMb PA3 HACPATb HE OTPE3BEET

*/

/* All following code is from old l.c file - somewhat simplified interface
   to interpreter. Strange bugz here (segfaults on alpha-dec-osf1) */

#define dfret NIL

Symbol *defRet();

int InitFuns();

int InitTFuns();
int InitForms();
int DefMFuns();
int CONTEXT_funs();
int ColorsF();

int uve_inited=0;

int lisp_init(int n) {
 extern void InitFFunc();
 if(uve_inited!=567) {
  FiI=stdin; lOf=stdout;
  heSz=256;
  frFp=0; 
  initglobtab(n);
  InitFuns();
  InitTFuns();
  InitForms();
  CONTEXT_funs();
  ColorsF();
  DefMFuns();
  InitFFunc();
  InitMiscFuns();
  uve_inited=567;
 } return 0;
}

int pri_res=0;

int lisp_ev(char *s)
{

 LIST s1,s2;
 LIST t;

 if(s==NIL) return 0;
 if(uve_inited!=567) lisp_init(600);
 frFp=0;
 frPos=0;

 s2=(LIST)malloc(sizeof(Symbol));
 IReader();
 t=readl(s);
 t->g=0;s2=t;
 s1=leval(t,&global);
 if(pri_res) {
  if(Typof(s1)==0 && ((ATOM)s1)->a!=NIL) {
   printf("LISP:: << %s\n",((ATOM)s1)->a);
  } else
  if(Typof(s1)==1 && s1!=NIL) {
   printf("LISP:: << ");printl(s1);
  }
 }
/* aatl1(s1);
 aatl1(s2);*/ /* FIXME */
 return 0;
}

int lisp_load(char *b)
{
 char *s;
 s=(char *)malloc(200);
 sprintf(s,"(load '%s) \n",b);
 lisp_ev(s);
 l_free(s);return 0;
}

int lisp_setqs(char *b, char *c)
{
 char *s;
 s=(char *)malloc(500);
 sprintf(s,"(setq %s '%s) \n",b,c);
 lisp_ev(s);
 l_free(s);return 0;
}

int lisp_setqi(char *b, int i)
{
 char *s;
 s=(char *)malloc(500);
 sprintf(s,"(setq %s %d) \n",b,i);
 lisp_ev(s);return 0;
 l_free(s);
}

int lisp_setqd(char *b, double i)
{
 char *s;
 s=(char *)malloc(500);
 sprintf(s,"(setq %s %f) \n",b,i);
 lisp_ev(s);
 l_free(s);return 0;
}

/* Signal Handling */



void IL_terminate_sig(int sig)
{
  printf("\nTERMINATED\n\n");
  fclose(lOf);
  exit(0);
}

void IL_init_signals()
{
#ifdef HAVE_SIGNALS
  if(signal(SIGINT,IL_terminate_sig)==SIG_IGN) signal(SIGINT,SIG_IGN);
  if(signal(SIGHUP,IL_terminate_sig)==SIG_IGN) signal(SIGHUP,SIG_IGN);
  if(signal(SIGTERM,IL_terminate_sig)==SIG_IGN) signal(SIGTERM,SIG_IGN);
  if(signal(SIGXCPU,IL_terminate_sig)==SIG_IGN) signal(SIGXCPU,SIG_IGN);
  if(signal(SIGPIPE,IL_terminate_sig)==SIG_IGN) signal(SIGPIPE,SIG_IGN);
  if(signal(SIGKILL,IL_terminate_sig)==SIG_IGN) signal(SIGKILL,SIG_IGN);
  if(signal(SIGQUIT,IL_terminate_sig)==SIG_IGN) signal(SIGQUIT,SIG_IGN);
#endif
}

/*END*/













