#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "l_defs.h"

/*
Forms functions (virtual pages):

pg <- (NewPage) --- create new virtual page
num <- (AddLine pg str) --- just add a line to end of page
num <- (LNum pg) --- number of the last line.
numl <- (InsertLine pg line num/numl) --- insert a line after numbered.
  numl is a list: (num chainnum)
(AddToLine pg num/numl line) --- continue numbered line
(DelLine pg num/numl) --- delete the numbered line
(ShowPage pg)         --- print page to stdout;
(DelPage pg)

  Text functions needed:
(FindAL name list)  --- from Form.l
(concat3 a b c)
(locate3 str sub chn)
(ExtrBraks str brl brr)

*/

typedef struct _pg {
	double num;
	double cnum; /* or 0 */
	uc *line;
	struct _pg *next, *nextn;
	LIST l;
	} FPage;                                        

FPage * MkPage()
{
 FPage *pg;
 pg=(FPage *)malloc(sizeof(FPage));
 pg->num=0.0;pg->cnum=0.0;pg->line=NULL;pg->next=NULL;pg->nextn=NULL;
 pg->l=NULL;
 return pg;
}

LIST LDMS_NewPage(symtab *tab,LIST l)
{
 LIST t1;
 ui i;
 FPage *pg;
 i=sizeof(FPage);
 pg=MkPage();
 t1=mklist((LIST)pg,(LIST)i);
 t1->f=7<<1;t1->g=0;
 return t1;
}

LIST LDMS_AddLine(symtab *tab,LIST l)
{
 LIST t1,t2;
 FPage *pg,*p;
 char *s;
 /*int i;*/
 t1=onesymeval(l->t.l,tab);
 t2=onesymeval(l->t.l->t.l,tab);
 pg=(FPage *)(((ATOM)t1)->a);
 p=pg;
 while(p->nextn!=NULL) p=p->nextn;
 p->nextn=MkPage();
 if(p->next==NULL) p->next=p->nextn;
 p->nextn->num=p->num+1;
 p=p->nextn;
 s=(char *)(((ATOM)t2)->a);
 p->line=(uc *)malloc(strlen(s)+5);
 strcpy(p->line,s);
 aatl1(t2);
/* t2=(LIST)MakeDAtom((double)(p->num));t2->g=0;*/
 t2=mklist((LIST)(&(p->num)),NIL);t2->f=4<<1;
 t2->g=1;
 p->l=t2;
 aatl1(t1);
 return t2; 
}

LIST LDMS_LNum(symtab *tab,LIST l)
{
 LIST t1,t2;
 FPage *pg,*p;
/* char *s;*/
/* int i;*/
 t1=onesymeval(l->t.l,tab);
 pg=(FPage *)(((ATOM)t1)->a);
 p=pg;
 while(p->nextn!=NULL) p=p->nextn;
// aatl1(t1);
/* if(p->l!=NULL) return p->l;*/
 t2=(LIST)MakeDAtom(p->num);t2->g=0;
/* t2=mklist((LIST)(&(p->num)),NIL);t2->f=4<<1;
 t2->g=1;
 p->l=t2;*/
 aatl1(t1);
 return t2; 
}

LIST LDMS_InsertLine(symtab *tab,LIST l)
{
 LIST t1,t2,t3;
 FPage *pg,*p,*ttt,*tt1;
 char *s;
/* int i;*/
 double num,cnum;
 t1=onesymeval(l->t.l,tab);
 t2=onesymeval(l->t.l->t.l,tab);
 t3=onesymeval(l->t.l->t.l->t.l,tab);
 pg=(FPage *)(((ATOM)t1)->a);
 p=pg;
 cnum=0;
 if((t3->f)&1) {
  num=GetDouble(t3->h.a);
  cnum=GetDouble(t3->t.l->h.a);
 } else
  num=GetDouble((ATOM)t3);
 
 while(p->next!=NULL) {
  if(p->num==num) {
   if(cnum==0.0) break;
   if(p->cnum==cnum) break;
  }
  p=p->next;
 }
 ttt=p->next;
 p->next=MkPage();
 tt1=p;
 if(p->cnum!=0.0) {
  while(tt1->next!=tt1->nextn) tt1=tt1->next;
  p->cnum=tt1->cnum+2.0;
 }
 p->next->num=p->num;p->next->cnum=p->cnum+1;
 p->next->next=ttt;
 p->next->nextn=p->nextn;
 p=p->next;
 s=(char *)(((ATOM)t2)->a);
 p->line=(uc *)malloc(strlen(s)+5);
 strcpy(p->line,s);
 aatl1(t2);aatl1(t3);
/* t2=mklist((LIST)MakeDAtom((double)(p->num)),
   mklist((LIST)MakeDAtom((double)(p->cnum)),NIL));t2->g=0;*/
 t2=mklist(mklist((LIST)(&(p->num)),NIL),
   mklist(mklist((LIST)(&(p->cnum)),NIL),NIL));
   t2->h.l->f=4<<1;t2->t.l->h.l->f=4<<1;
 t2->g=1;
 p->l=t2;
 aatl1(t1);
 return t2; 
}

LIST LDMS_AddToLine(symtab *tab,LIST l)
{
 LIST t1,t2,t3;
 FPage *pg,*p;
 char *s,*s1;
/* int i;*/
 double num,cnum;
 t1=onesymeval(l->t.l,tab);
 t2=onesymeval(l->t.l->t.l,tab);
 t3=onesymeval(l->t.l->t.l->t.l,tab);
 pg=(FPage *)(((ATOM)t1)->a);
 p=pg;
 cnum=0;
 if((t3->f)&1) {
  num=GetDouble(t3->h.a);
  cnum=GetDouble(t3->t.l->h.a);
 } else
  num=GetDouble((ATOM)t3);
 
 while(p->next!=NULL) {
  if(p->num==num) {
   if(cnum==0.0) break;
   if(p->cnum==cnum) break;
  }
  p=p->next;
 }
 s1=p->line;
 s=(char *)(((ATOM)t2)->a);
 p->line=(uc *)malloc(strlen(s)+strlen(s1)+5);
 strcpy(p->line,s1);
 strcpy((p->line)+strlen(s1),s);
 free(s1);
 aatl1(t2);aatl1(t3);
 aatl1(t1);
 return dfret; 
}

LIST LDMS_ShowPage(symtab *tab,LIST l)
{
 LIST t1;
 FPage *pg,*p;
 


 t1=onesymeval(l->t.l,tab);
 pg=(FPage *)(((ATOM)t1)->a);
 p=pg;
 while(p!=NULL) {
  if(p->line!=NULL) {fprintf(lOf,"%s\n",p->line);}
  p=p->next;
 }
 return dfret; 
}

LIST LDMS_DelPage(symtab *tab,LIST l)
{
 LIST t1;
 FPage *pg,*p;
 
 

 t1=onesymeval(l->t.l,tab);
 pg=(FPage *)(((ATOM)t1)->a);
 ((ATOM)t1)->a=NULL;
 p=pg;
 while(p!=NULL) {
  pg=p;
  p=p->next;
  if(pg->l!=NULL) {
   if((pg->l->f)&1) {pg->l->h.a->a=NULL;pg->l->t.l->h.a->a=NULL;} else {
    pg->l->h.l=NULL;
   }
   pg->l->g--;aatl1(pg->l);
  }
  free(pg->line); free(pg);
 }
 return t1; 
}

LIST LDMS_FindAL(symtab *tab,LIST l)
{
 LIST t1,t2,t3;
 
 t1=onesymeval(l->t.l,tab); /* name */
 t2=onesymeval(l->t.l->t.l,tab); /* rules list */
 t3=t2;
 while(t3!=NULL) {
  if(!strcmp(((ATOM)t1)->a,t3->h.l->h.a->a)) {
   aatl1(t1);
   t3->h.l->g++; aatl1(t2); t3->h.l->g--;
   return t3->h.l;
  }
  t3=t3->t.l; 
 }
 aatl1(t1);aatl1(t2);
 return NIL;
}

LIST LDMS_concat3(symtab *tab,LIST l)
{
 LIST t1,t2,t3;
 char *s,*s1,*s2,*s3;
 ui l1,l2,l3;
 t1=onesymeval(l->t.l,tab);
 t2=onesymeval(l->t.l->t.l,tab);
 t3=onesymeval(l->t.l->t.l->t.l,tab);
 s1=((ATOM)t1)->a;s2=((ATOM)t2)->a;s3=((ATOM)t3)->a;
 l1=strlen(s1);l2=strlen(s2);l3=strlen(s3);
 s=(char *)malloc(l1+l2+l3+2);
 strcpy(s,s1);
 strcpy(s+l1,s2);
 strcpy(s+l1+l2,s3);
 aatl1(t1);aatl1(t2);aatl1(t3);
 t1=mklist((LIST)s,NIL);t1->f=0;t1->g=0;
 return t1;
}

InitForms()
{
 deffun("ShowPage",&LDMS_ShowPage);
 deffun("AddToLine",&LDMS_AddToLine);
 deffun("InsertLine",&LDMS_InsertLine);
 deffun("LNum",&LDMS_LNum);
 deffun("AddLine",&LDMS_AddLine);
 deffun("NewPage",&LDMS_NewPage);
 deffun("DelPage",&LDMS_DelPage);
 deffun("FindAL",&LDMS_FindAL);
 deffun("concat3",&LDMS_concat3);
 return 0;
}
