(define (primv-functor tab-file aux-mod)

  (let* ((port (open-input-file tab-file))
	 (tab (with-input-from-port port read)))

    (close-port port)

    (module primv-sig (tab)

      (use scheme-sig)
      (use aux-mod aux-sig)

      (define (extract l p)
	(map cdr (filter l p)))

      (define (build-a x) (cons (caddr x) (cadr x)))

      (define (r4rs? x) (eq? (car x) 'r4rs))
      (define (user? x) (eq? (car x) 'user))
      (define (system? x) (eq? (car x) 'system))
      (define (posix? x) (eq? (car x) 'posix))

      (define r4rs-values (extract tab r4rs?))
      (define user-values (extract tab user?))
      (define system-values (extract tab system?))
      (define posix-values (extract tab posix?))

      ;; this should be optimized... (hashtable or such)
      (define index-map (map build-a tab))

      (define (index->primitive i)
	(cond ((assv i index-map) => cdr)
	      (else #f)))

      (set! tab #f))))			; kill space
