(define (integ-functor lgi-mod optutil-mod soft-mod)

  (module integ-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lgi-mod lgi-sig)
    (use optutil-mod optutil-sig)
    (use soft-mod soft-sig soft)

    (define (integ exp)

      (define rts-v (new-local 'run-time-system))

      (define soft-mapping '())

      (define (soft-translate sy)
	(cond ((assoc sy soft-mapping) => cdr)
	      (else
	       (let ((n (new-local sy)))
		 (set! soft-mapping (cons (cons sy n) soft-mapping))
		 n))))

      (define (rts-request r)
	(ee 'app (list rts-v (ee 'quote r))))

      (define (int exp)
	(case (ee-type exp)
	  ((integrable)
	   (let ((sy (integrable-symbol exp)))
	     (case sy
	       ((register-module) (rts-request '(register-module)))
	       ((fetch-module) (rts-request '(fetch-module)))
	       (else
		(if (or (pair? sy)
			(memq sy (soft soft-builtin-names)))
		    (soft-translate sy)
		    exp)))))
	  (else (generic int exp))))

      (let ((e (int exp)))
	(ee 'lambda
	    (list "[Top]"
		  (list rts-v)
		  (ee 'letrec
		      (list (map (lambda (m)
				   (list (cdr m)
					 (rts-request
					  (cons 'get-integrable (car m)))))
			      soft-mapping)
			    e))))))))
