(define (eff-functor aux-mod lgi-mod optutil-mod error-mod)

  (module eff-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lgi-mod lgi-sig)
    (use aux-mod aux-sig)
    (use optutil-mod optutil-sig)
    (use error-mod error-sig)

    ;; does some expression depend on data mutation (conservative)?
    (define (could-depend-on-effect? exp)
      (define (letrec-label bl-sel e-sel)
	(let ((b (ee-body exp)))
	  (or (could-depend-on-effect? (e-sel b))
	      (contains (bindapp could-depend-on-effect?) (bl-sel b)))))
      (case (ee-type exp)
	((quote integrable lambda vlambda delay local) #f)
	((if) (contains could-depend-on-effect? (ee-body exp)))
	((letrec let) (letrec-label car cadr))
	((label) (letrec-label cadr caddr))
	((app)
	 (let* ((body (ee-body exp))
		(f (car body)))
	   (or (not (integrable? f))
	       (not (memq (integrable-symbol f)
			  '(not + - * < > <= >= = zero? null? pair?
				boolean? number? cons append list
				vector list->vector ref memv eqv? eq?)))
	       (contains could-depend-on-effect? (cdr body)))))
	(else #t)))


    ;; effects in exp (conservative)?
    (define (could-have-effect? exp)

      (define (eff? exp labels)

	(define (same-eff? exp) (eff? exp labels))

	(case (ee-type exp)
	  ((quote global integrable local lambda vlambda delay) #f)
	  ((set!) #t)
	  ((if) (contains same-eff? (ee-body exp)))
	  ((let letrec)
	   (let ((body (ee-body exp)))
	     (or (same-eff? (cadr body))
		 (contains (bindapp same-eff?) (car body)))))
	  ((goto)
	   (let ((body (ee-body exp)))
	     (or (not (memv (car body) labels))
		 (contains same-eff? (cdr body)))))
	  ((label)
	   (let ((body (ee-body exp)))
	     (or (eff? (caddr body) (cons (car body) labels))
		 (contains (bindapp same-eff?) (cadr body)))))
	  ((app)
	   (let* ((body (ee-body exp))
		  (f (car body)))
	     (or (not (integrable? f))
		 (not (memq (integrable-symbol f)
			    '(not + - * < > <= >= = zero? null? pair?
				  boolean? number? cons append list
				  vector list->vector ref deref car cdr
				  fetch-constant fetch-variable
				  fetch-read-only fetch-module)))
		 (contains same-eff? (cdr body)))))
	  (else
	   (bug
	    "opt: could-have-effect?: funny expression type: "
	    (ee-type exp)))))

      (eff? exp '()))))
