(lambda (args)

  (use system-sig)

  (define (no what)
    (with-output-to-port
	(standard-port 2)
      (lambda ()
	(display "!* boot: no ")
	(display what)
	(newline)
	(quit 1))))

  ;; minimal rts code (this is duplicated from rts.scm)
  (define cadrs '())

  (define (construct-cadr l)
    (let* ((str (string-append
		 "c"
		 (list->string
		  (reverse
		   (map (lambda (x) (if (eq? x 'car) #\a #\d)) l)))
		 "r"))
	   (code `("dummy" 1 #f #(rts)
			   ((,str 1 #f #(x) () 2 0 ,@(map list l) (exit)))
			   3 0
			   (take-false) (lambda 0) (exit))))
      (run-asm code)))

  (define (get-cadr l)
    (cond ((assoc l cadrs) => cdr)
	  (else (let ((n (construct-cadr l)))
		  (set! cadrs (cons (cons l n) cadrs))
		  n))))

  (define (process-file file)

    (define (err m)
      (with-output-to-port
	  (standard-port 2)
	(lambda ()
	  (display "!* boot: error in source file ")
	  (display file)
	  (display " (")
	  (display m)
	  (display ")")
	  (newline)
	  (quit 1))))

    (with-error-handler
     (lambda (m ec)
       (with-output-to-port
	   (standard-port 2)
	 (lambda ()
	   (display "!* boot: ")
	   (display file)
	   (display ": ")
	   (display m)
	   (newline)
	   (quit 1))))

     (lambda ()

       (define (process form)

	 (if (not (pair? form))
	     (err form))

	 (case (car form)
	   ((run-asm) (run-asm (cadadr form)))
	   (else (err "unrecognized construct"))))

       (let ((port (open-input-file file)))
	 (do ((form (read port) (read port)))
	     ((eof-object? form) (close-port port))
	   (process form))))))

  ;; implements a minimal run-time system to resolve references to
  ;; members of the cadr-family
  (define (dispatch sy arg)
    (if (and (eq? sy 'get-integrable)
	     (pair? arg))
	(get-cadr arg)
	(no (string-append
	     "full runtime system available: "
	     (string-write arg)))))

  (cond ((and (pair? args) (symbol? (car args)))
	 (dispatch (car args) (cdr args)))
	((list? args) (for-each process-file args))
	(else (no "argument list"))))
