/*
 * Promise.c -- Implementation of Scheme Promises
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Promise.c,v 2.6 1994/11/12 22:17:15 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: Promise.c,v 2.6 1994/11/12 22:17:15 blume Exp $")

# include <stdio.h>

# include "storext.h"
# include "Promise.h"
# include "identifier.h"

static void iterator (void *vprom, MEM_visitor proc, void *cd)
{
  ScmPromise *prom = (ScmPromise *) vprom;

  (*proc) ((void *)&prom->env, cd);
  (*proc) ((void *)&prom->code_or_value, cd);
}

static void display (void *vprom, putc_proc pp, void *cd)
{
  char buf [32];

  sprintf (buf, "#<Promise %p>", vprom);
  putc_string (buf, pp, cd);
}

MEM_VECTOR (Promise,
	    MEM_UNITS (sizeof (ScmPromise)), MEM_NULL_measure,
	    iterator, MEM_NULL_dumper, MEM_NULL_excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));
