/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __BOOKMARKS_H__
#define __BOOKMARKS_H__

#include"ui.h"

typedef struct
{
	char mark;
	char file[NAME_MAX];
	char directory[PATH_MAX];
}bookmarks_t;

bookmarks_t bookmarks[62];

void add_bookmark(char mark, char *directory, char *file);
int get_bookmark(FileView *view);
int move_to_bookmark(FileView *view, char mark);
void remove_bookmark(char mark);
int sort_bookmarks(const void *one, const void *two);
int check_mark_directory(FileView *view, char mark);

#endif
