/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<string.h>
#include<ctype.h> /* isalnum() */

#include "bookmarks.h"
#include "config.h"
#include "filelist.h"
#include "keys.h"
#include "status.h"
#include "ui.h"
#include "utils.h"


int
sort_bookmarks(const void *one, const void *two)
{
	const bookmarks_t *first = (const bookmarks_t *)one;
	const bookmarks_t *second = (const bookmarks_t *)two;
	return first->mark - second->mark;
}

static int
find_bookmark(char mark)
{
	int x;
	int found = 0;
	for(x = 0; x < cfg.bookmarks_pos; x++)
	{
		if(bookmarks[x].mark == mark)
		{
			found = 1;
			break;
		}
	}
	if(found)
		return x;
	else
		return -1;
}

void
remove_bookmark(char mark)
{
	int x = find_bookmark(mark);
	if(x < 0)
	{
		status_bar_message("Could not find mark");
		return;
	}

	cfg.bookmarks_pos--;
	while(x < cfg.bookmarks_pos)
	{
		bookmarks[x].mark = bookmarks[x + 1].mark;
		strcpy(bookmarks[x].directory, bookmarks[x + 1].directory);
		strcpy(bookmarks[x].file, bookmarks[x + 1].file);
		x++;
	}
}

void
add_bookmark(char mark, char *directory, char *file)
{
	int x ;
	int pos;

	if(!isalnum(mark))
	{
		status_bar_message("Invalid mark");
		return;
	}
	x = find_bookmark(mark);

	/* The mark is already being used.  It is going to be replaced */
	if(x != -1)
		pos = x;
	else if(x == '\'')
		return;
	else
	{
		pos = cfg.bookmarks_pos;
		cfg.bookmarks_pos++;
		/* Just a safety check.  I'm not sure that I have the key handling set 
		 * correctly yet.
		 */
		if(cfg.bookmarks_pos > 61)
		{
			cfg.bookmarks_pos--;
			status_bar_message("Error in bookmarks.c line 98");
			return;
		}
	}

	bookmarks[pos].mark = mark;
	strcpy(bookmarks[pos].directory, directory);
	strcpy(bookmarks[pos].file, file);
}

int 
move_to_bookmark(FileView *view, char mark)
{
	int x  = find_bookmark(mark);
	int file_pos = -1;

	if(x != -1)
	{
		change_directory(view, bookmarks[x].directory);
		load_dir_list(view, 1);
		file_pos = find_file_pos_in_list(view, bookmarks[x].file);
		if(file_pos != -1)
			moveto_list_pos(view, file_pos);
		else
			moveto_list_pos(view, 0);
	}
	else
	{
		if(!isalnum(mark))
			status_bar_message("Invalid mark");
		else
			status_bar_message("Mark not set.");

		moveto_list_pos(view, view->list_pos);
		return 1;
	}
	return 0;
}

int
check_mark_directory(FileView *view, char mark)
{
	int x = find_bookmark(mark);
	int file_pos = -1;

	if(strcmp(view->curr_dir, bookmarks[x].directory) == 0)
		file_pos = find_file_pos_in_list(view, bookmarks[x].file);

	return file_pos;

}

int
get_bookmark(FileView *view)
{
	int key;

	curr_stats.getting_input = 1;
	key = wgetch(view->win);
	curr_stats.getting_input = 0;

	switch(key)
	{
		case '\'':
			{
				change_directory(view, view->last_dir);
				load_dir_list(view, 0);
				moveto_list_pos(view, view->list_pos);
				return 0;
			}
			break;
		case 27: /* ascii Escape */
		case 3: /* ascii ctrl c */
			moveto_list_pos(view, view->list_pos);
			return 0;
			break;
		default:
			return move_to_bookmark(view, key);
			break;
	}
	return 0;
}
