/* @(#)strtoix.c	1.6 */

#include <config.h>

#include <errno.h>
#include <ctype.h>

#include <utftools.h>

/*
 * strtoix(name, base)
 *
 * The strtoix() function converts a string to an integer. A valid
 * string consists of optional leading white space, an integer
 * acceptable to strtoi(), and optional leading trailing space. If the
 * string is not valid, strtoix() returns zero and sets errno to EDOM;
 * otherwise it returns as strtoi().
 */
int
strtoix(const char *str, int base)
{
	int value;
	char *end;
	
	value = strtoi(str, &end, base);
	
	while (*end != 0 && isspace(*end))
		++end;
	if (*end != 0) {
		errno = EDOM;
		value = 0;
	}

	return value;
}
