/*
 * Get or Post a URL
 */

#ifndef lint
char *rcsid = "@(#)urlget.c,v 1.9 2004/02/15 20:56:35 kim Exp";
#endif

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "porting.h"

#define DEF_PORT	80
#define MAX_RDBUF	1024

extern int optind;
extern char *optarg;

/* sends a suitably escaped header and body for a POST command */
static void sendpostarg(FILE *fp, char **postargv)
{
  int count, i, nargs = 0, sawEQ;
  size_t arglen = 0;
  char *p, c;

  fprintf(fp, "Content-Type: application/x-www-form-urlencoded\r\n");
  count = 0;

  /*
   * first, figure out the length of the query, counting all characters that
   * will need to be escaped.  First '=' in an arg is not escaped, it's
   * assumed to be the real delimiter in the 'name=value' arguments. So
   * name=value=value becomes name=value%3Dvalue before transmission.
   */
  for (i = 0; postargv[i] != NULL; i++) {
    arglen += strlen(postargv[i]);
    nargs++;
    sawEQ = 0;
    for (p = postargv[i]; (c = *p) != '\0'; p++) {
      if (isalnum(c))
	continue;
      if (c == '=' && !sawEQ) {
	sawEQ++;
	continue;
      }
      count++;
    }
  }
  /* chars in strings + & separators between args + escaped chars */
  fprintf(fp, "Content-Length: %lu\r\n\r\n", nargs == 0 ? 0 :
	  (unsigned long) (arglen + (nargs - 1) + count * 2));

  /* now print the actual query, escaping all relevant characters */
  for (i = 0; postargv[i] != NULL; i++) {
    sawEQ = 0;
    for (p = postargv[i]; (c = *p) != '\0'; p++) {
      if (isalnum(c)) {
	putc(c, fp);
      } else if (c == '=' && !sawEQ) {
	sawEQ++;
	putc(c, fp);
      } else {
	fprintf(fp, "%%%02X", (unsigned) (c & 0xFF));
      }
    }
    if (postargv[i+1] != NULL)
      putc('&', fp);
  }
}

volatile void usage(char *me)
{
  fprintf(stderr, "Usage: %s [-DPRhop] URL [postarg ...]\n", me);
  fprintf(stderr, "       -D  debug: only show request in stdout\n");
  fprintf(stderr, "       -P  disable proxy\n");
  fprintf(stderr, "       -R  force proxy reload\n");
  fprintf(stderr, "       -h  send a HEAD request (headers only)\n");
  fprintf(stderr, "       -o  old: use HTTP/0.9\n");
  fprintf(stderr, "       -p  send a POST request (submit variables)\n");
  exit(1);
}

int main(int argc, char **argv)
{
  struct hostent *gethostbyname();
  struct hostent *hp;
  struct servent *sp;
  struct sockaddr_in server;
  char *url, *cmd = "GET", data[MAX_RDBUF], *p, *ep, *path, *host;
  char **postargv = NULL;
  int c, ret, s = 0, count, sawNL;
  int errflg = 0, postflg = 0, hdrflg = 0, oldflg = 0, debug = 0;
  int isproxy = 0, noproxy = 0, revalidate = 0;
  FILE *fp;

  while ((c = getopt(argc, argv, "DPRhop")) != EOF) {
    switch (c) {
    case 'D':
      ++debug;
      break;
    case 'P':
      ++noproxy;
      break;
    case 'R':
      ++revalidate;
      break;
    case 'h':
      cmd = "HEAD";
      ++hdrflg;
      break;
    case 'o':
      ++oldflg;
      break;
    case 'p':
      cmd = "POST";
      ++postflg;
      break;
    default:
      ++errflg;
      break;
    }
  }
  if (errflg || optind >= argc || (postflg && optind >= argc) ||
      (!postflg && optind != argc - 1))
    usage(argv[0]);

  if (oldflg && (postflg || hdrflg)) {
    fprintf(stderr, "%s: cannot use -o with -p or -h\n", argv[0]);
    exit(1);
  }

  url = argv[optind];
  if (postflg)
    postargv = &argv[optind+1];
  host = url + 7;

  if (strncmp(url, "http:", 5) || (url[5] != '/') || (url[6] != '/'))
    usage(argv[0]);

  if (noproxy || ((p = getenv("http_proxy")) == NULL)) {
	if ((path = strchr(host, '/')) == NULL)
		usage(argv[0]);
	*path++ = '\0';
	if ((p = strchr(host, ':')) != NULL) {
		*p++ = '\0';
		server.sin_port = htons((u_short) atoi(p));
	} else if ((sp = getservbyname("http", "tcp")) == NULL) {
		server.sin_port = htons((u_short) DEF_PORT);
	} else {
		server.sin_port = sp->s_port;
	}
  } else {
	host = &p[7];
	if ((ep = strchr(host, ':')) == NULL) {
		server.sin_port = htons((u_short) DEF_PORT);
	} else {
		*ep++ = 0;
		server.sin_port = htons((u_short) atoi(ep));
	}
	if ((ep = strrchr(p, '/')) != NULL) {
		*ep = 0;
	}
	path = url;
	isproxy = 1;
  }

  if ((hp = gethostbyname(host)) == NULL) {
    fprintf(stderr, "%s: Unknown host: %s\n", argv[0], host);
    exit(2);
  }
  server.sin_family = hp->h_addrtype;
  memcpy((char *) &server.sin_addr, hp->h_addr, hp->h_length);

  if (!debug) {
    if((s = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0) {
      perror("socket");
      exit(3);
    }

    if(connect(s, (SOCKET) &server, sizeof(server)) == -1) {
      perror(host);
      exit(4);
    }
    if ((fp = fdopen(s, "w")) == NULL) {
      perror("fdopen");
      exit(5);
    }
  } else {
    /* debugging, print our request to stdout */
    fp = stdout;
    printf("host = \"%s\", port = %d\n", host, ntohs(server.sin_port));
  }

  fprintf(fp, "%s %s%s%s\r\n", cmd, (isproxy) ? "" : "/", path, oldflg ? "" : " HTTP/1.0");
  if (!oldflg) {
      fprintf(fp, "Host: %s\r\n", host);
  }
  if (revalidate) {
      fprintf(fp, "Cache-Control: max-age=0\r\n");
  }
  if (postflg) {
    sendpostarg(fp, postargv);
  }
  fprintf(fp, "\r\n");
  fflush(fp);

  /* this is all for debugging */
  if (debug)
    exit(0);

  /* read first block */
  count = read(s, data, sizeof data);
  if (count < 0) {
    perror("read");
    exit(6);
  } else if (count == 0) {
    exit(7);
  }
  p = data;
  ep = data + count;

  ret = 0;
  if (!oldflg && !hdrflg) {
    /* process reply status */
    /* HTTP/1.0 200 ... */
    if (count > 12 && strncmp(p, "HTTP/", 5) == 0) {
      p += 5;
      while (isascii(*p) && (isdigit(*p) || *p == '.'))
	p++;
      while (*p == ' ')
	p++;
      if (*p != '2') {
	/* exit status is first two digits of return code */
	ret = atoi(p) / 10;
	while (isascii(*p) && (*p != '\r' && *p != '\n'))
	  p++;
	c = *p;
	*p = '\0';
	fprintf(stderr, "%s: server return code %d: %s\n", argv[0], ret, data);
	*p = c;
      }
      count -= (p - data);
      sawNL = 0;
      /* now skip over headers i.e till we see a blank line. */
      while (sawNL < 2) {
	if (p == ep) {
	  /* unlikely for headers to require more than one read(), but... */
	  count = read(s, data, sizeof data);
	  if (count < 0) {
	    perror("read");
	    exit(6);
	  } else if (count == 0) {
	    exit(ret);
	  }
	  p = data;
	  ep = data + count;
	}
	c = *p++;
	count--;
	if (c == '\n') {
	  sawNL++;
	} else if (c != '\r') {
	  sawNL = 0;
	}
      }
    }
  }

  /* copy the rest to stdout. */
  do {
    if (count > 0 && write(1, p, count) != count) {
      perror("write");
      exit(6);
    }
    p = data;
  } while ((count = read(s, data, sizeof data)) > 0);
  if (count < 0) {
    perror("read");
    exit(6);
  }
  exit(ret);
}
