/**
 * @filename	stats-uxw.c
 *
 * @desc	Retrieve stats for the UnixWare platform
 */

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <string.h>
#include <sys/utsname.h>

/**
 * @desc	Get statistics
 */
void getstats(unsigned long *puptime, double *pload, int *pidle, char *os, char *oslevel, char *cpu) {
  struct utsname uts;
  FILE *fp;
  char dummy_str[100];
  int days;
  char uptime_today[10];
  unsigned long uptime_mins;
  int temp;
  char sar_cmd[40];
  int pct_idle;
  int i;

  /* Get uptime */
  fp = popen("/usr/bin/uptime", "r");
  if(!fp)
    exit(-2);

  if(fscanf(fp, "%s %s %d %s %s %s", dummy_str, dummy_str, &days, dummy_str, uptime_today, dummy_str) < 2)
    exit(-3);
  fclose(fp);
  uptime_mins = days * 24 * 60;
  temp = atoi(strtok(uptime_today, ":"));
  uptime_mins += temp * 60;
  temp = atoi(strtok(0, ":"));
  *puptime = uptime_mins + temp;

  if(cfg_sendidle) {
    /* Get idle time for the current interval */
    sprintf(sar_cmd, "/usr/bin/sar %d 1", cfg_interval);
    fp = popen(sar_cmd, "r");
    fgets(dummy_str, sizeof(dummy_str), fp);  /* blank */
    fgets(dummy_str, sizeof(dummy_str), fp);  /* same as "uname -a" */
    fgets(dummy_str, sizeof(dummy_str), fp);  /* blank */
    fgets(dummy_str, sizeof(dummy_str), fp);  /* header line */
    fscanf(fp, "%s %d %d %d %d", dummy_str, &temp, &temp, &temp, &pct_idle);
    fclose(fp);

    /* First time through, init idle array to the first idle value we
       capture.  That seems most fair. */
    if(past_idle_times[0] == -1)
      for(i = 0; i < NUM_IDLE_ELEMENTS; ++i)
        past_idle_times[i] = pct_idle;

    /* Add interval to idle array, and calculate the average idle time. */
    temp = 0;
    for(i = 1; i < NUM_IDLE_ELEMENTS; ++i)
      temp += (past_idle_times[i - 1] = past_idle_times[i]);

    temp += (past_idle_times[NUM_IDLE_ELEMENTS - 1] = pct_idle);
    *pidle = temp / (NUM_IDLE_ELEMENTS);
  }

  if(cfg_sendos) {
    /* Get os info */
    uname(&uts);
  } else {
    if(cfg_sendcpu) {
      /* Get CPU info */
      uname(&uts);
    }
  }

  if(cfg_sendos) {
    strncpy(os, uts.sysname, OS_SIZE - 1);
    if(strcmp(os, "UNIX_SV") == 0) {
      strcpy(os, "UnixWare"); /* Change a stupid OS name to something marginally less stupid. */
    }
    if(cfg_sendoslevel) {
      /* strncpy(oslevel, uts.release, OSLEVEL_SIZE - 1); */
      strncpy(oslevel, uts.version, OSLEVEL_SIZE - 1);
    }
  }

  if(cfg_sendcpu) {
    strncpy(cpu, uts.machine, CPU_SIZE - 1);
  }
}
