/**
 * Uptime Client v4.2
 *
 * network.h
 */

#ifndef _NETWORK_H_
#define _NETWORK_H_ 1

#include <stdlib.h>

#ifdef PLATFORM_WINNT
  /* translate some socket functions */
  #define close(X)	closesocket(X)
  #define read(X,Y,Z)	recv(X,Y,Z,MSG_PEEK)
  #define write(X,Y,Z)	send(X,Y,Z,0)
  #define ssize_t	int
#endif

#ifdef PLATFORM_BEOS
  /* translate some socket functions */
  #define close(X)      closesocket(X)
  #define read(X,Y,Z)   recv(X,Y,Z,0)
  #define write(X,Y,Z)  send(X,Y,Z,0)
#endif

extern int socket_write(int, const char *, size_t);
extern int socket_read(int, char *, size_t);
#if defined(PLATFORM_WINNT)
extern void startWinsock(void);
#endif

#endif
