/**
 * @filename	base64.c
 *
 * @desc	Base64 encoding
 */

/* My includes */
#include "base64.h"

/* System includes */
#include <stdio.h>
#if !defined(PLATFORM_WINNT) && !defined(PLATFORM_BEOS)
  #include <syslog.h>
#endif

/* Base64 table (-: */
static char base64_table[] = {
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
  'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '\0'
};

/* Padding character */
static char base64_pad = '=';

/**
 * @desc	Base64 encode a neat little string
 */
unsigned char *base64_encode(const unsigned char *string) {
  int length = strlen((char *)string);
  const unsigned char *current = string;
  int i = 0;
  unsigned char *result = (unsigned char *)malloc(((length + 3 - length % 3) * 4 / 3 + 1) * sizeof(char));

  if(result == NULL) {
#if !defined(PLATFORM_WINNT) && !defined(PLATFORM_BEOS)
    syslog(LOG_ERR, "base64_encode(): out of memory");
#endif
    exit(1);
  }

  while(length > 2) { /* keep going until we have less than 24 bits */
    result[i++] = base64_table[current[0] >> 2];
    result[i++] = base64_table[((current[0] & 0x03) << 4) + (current[1] >> 4)];
    result[i++] = base64_table[((current[1] & 0x0f) << 2) + (current[2] >> 6)];
    result[i++] = base64_table[current[2] & 0x3f];

    current += 3;
    length -= 3; /* we just handle 3 octets of data */
  }

  /* now deal with the tail end of things */
  if(length != 0) {
    result[i++] = base64_table[current[0] >> 2];
    if(length > 1) {
      result[i++] = base64_table[((current[0] & 0x03) << 4) + (current[1] >> 4)];
      result[i++] = base64_table[(current[1] & 0x0f) << 2];
      result[i++] = base64_pad;
    }
    else {
      result[i++] = base64_table[(current[0] & 0x03) << 4];
      result[i++] = base64_pad;
      result[i++] = base64_pad;
    }
  }
  result[i] = '\0';
  return result;
}
