#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <AImmHzInput.hpp>
#include <UniKey.hpp>

CAImmHzInput::CAImmHzInput (int nTty, ImmServer_T ImmServer0,
                      CMyConfig *pMyConfig,
                      CUniKey *pCMyKey0)
{
    pCMyKey = pCMyKey0;
    pCMyInputArea = new CMyInputArea (nTty, pMyConfig, pCMyKey);
    ImmServer = ImmServer0;
    IsMakingPhrase = 0;
    bShowFirstStartMsg = 1,
    IsHelpMenu = 0,
    IsSysMenu = 0,
    IsFullChar = 0,
    IsHanziInput = 0,
    IsFullComma = 0;
    IsHanziInputBackup = 0,
    IsFullCharBackup = 0,
    IsFullCommaInChinese = 0,
    IsFullCommaInEnglish = 0;
    ShowTipItem = 0;
    nTotalSelection = 0;
    pImm = NULL;
}

int CAImmHzInput::OpenInputMethod 
            (char *szImmModule, 
             char *szImmTable, 
             u_long type,
             char *szMethod) 
{
    IMM *p;
    if (IsMakingPhrase == 1)
        return 0;
    printf ("%ld %s %s %ld\n", ImmServer, szImmModule, szImmTable, type);
    CloseInputMethod ();
    p = IMM_OpenInput (ImmServer, szImmModule, szImmTable, type);

    assert (p != NULL);

    /* Save all the system phrase and user phrase into disk */
    DoFlush ();

    /* Reset the Input method */
    // CloseInputMethod ();
    pImm = p;
    pCMyInputArea->SetNewMethod (szMethod);
    return 1;
}

int CAImmHzInput::CloseInputMethod () 
{
    if (IsMakingPhrase == 1)
        return 0;
    if (pImm == NULL)
        return 0;
    IMM_CloseInput (pImm);
    pCMyInputArea->SetNewMethod ("Unknow");
    return 1;
}

CAImmHzInput::~CAImmHzInput ()
{
    CloseInputMethod ();
    delete pCMyInputArea;
}

int CAImmHzInput::KeyFilter (u_char key, char *buf, int *len)
{
    if (pImm == NULL)
        return 0;
    int n = IMM_KeyFilter (pImm, key, buf, len);
    RefreshInputArea ();
    return n;
}

int CAImmHzInput::RefreshInputMode ()
{
    long mode = 0;
    if (pImm == NULL)
        return 0;
    if (IsFullChar)
        mode |= IMM_FULL_CHAR_MODE;
    if (IsHanziInput)
        mode |= IMM_DOUBLE_BYTE_MODE;
    if (IsFullComma)
        mode |= IMM_FULL_SYMBOL_MODE;
    return IMM_SetInputMode (pImm, mode);
}

void CAImmHzInput::RefreshInputArea ()
{
   pCMyInputArea->ClearInputArea ();
   if (bShowFirstStartMsg == 1)
       pCMyInputArea->ShowFirstStartMsg ();
   else if (IsHelpMenu == 1)
       pCMyInputArea->ShowHelpItem (ShowTipItem);
   else if (IsSysMenu == 1)
       pCMyInputArea->ShowSysMenu ();
   else
   {
       if (pImm == NULL)
           return;
       int which;
       if (IsFullChar == 1)
           which = 3;
       else
           which = IsHanziInput;
       char buf[1024];

       if (IMM_GetInputDisplay (pImm, buf, sizeof (buf)) == 0)
           buf[0] = '\0';
       pCMyInputArea->SetInputDisplay (buf);
       nTotalSelection = IMM_GetSelectDisplay (pImm, buf, sizeof (buf));
       if (nTotalSelection == 0)
           buf[0] = '\0';
       pCMyInputArea->SetSelectDisplay (buf);
       pCMyInputArea->RefreshInputArea (which, IsFullComma);
   }
}
void CAImmHzInput::ResetInput ()
{
    IMM_ResetInput (pImm);
}

int CAImmHzInput::MakingUserPhrase (char *szCode, char *szPhrase)
{
    IMM_AddUserPhrase (pImm, szCode, szPhrase, USER_PHRASE_FREQ);
    DoFlush (); 
    return 1;
}

void CAImmHzInput::DoFlush ()
{
/*
    if (pImm != NULL) 
        IMM_FlushUserPhrase (pImm); 
 */
}

int CAImmHzInput::WriteUserDefinedPhrase (char *szPhrase, int len)
{
   if (IsMakingPhrase)
   {
       char buf[256];
       int n = strlen (szUserPhrase);

       if (len == 1 && isalnum (szPhrase[0]) == 0)
       {
           switch (szPhrase[0])
           {
               case '\010':  /* BackSpace Ctrl+H */
               case '\177':  /* BackSpace */
                   if (isalnum (szUserPhrase[n-1]) == 1)
                       n --;
                   else
                       n -= 2;
                   if (n < 0)
                       n = 0;
                   break;
               default:
                   return 1;
           }
       }
       else
       {
           memcpy (&szUserPhrase[n], szPhrase, len);
           n += len;
       }
       szUserPhrase[n] = '\0';
       sprintf (buf, ":<%s>%s", szUserPhraseCode, szUserPhrase);
       pCMyInputArea->SetNewMethod (buf);
       RefreshInputArea ();
       return 1;
   }
   return 0;
}

void CAImmHzInput::GetInputDisplay (char *buf, int len)
{
   char buf0[256];
   if (pImm == NULL)
      return;
   if (IsFullChar == 1)
      return;
   if (IMM_GetInputDisplay (pImm, buf0, sizeof (buf0)) == 0)
   {
      buf[0] = '\0';
      return;
   }
   char *p = buf;
   for (int i = 0; i < (int) strlen (buf0); i++)
   {
      if (buf0[i] == '-')
         continue;
      if (buf0[i] == ' ')
         break;
      *p++ = buf0[i];
   }
   *p = '\0';
}
