/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Controls events handling for the UBS, which generally includes special things that must be played at regular intervals.  This will be of great use to actual radio stations, but may be strictly optional for regular users.  Events have been modularized from internal functions to separate executable programs.  Events need not be concerned with playing music; they can also do regular maintainance jobs for the UBS such as recache the search engine and such things.  The events scheduler is meant to act as a very primitive cron for the UBS, doing things at certain times every hour.
  It would be nice to rework the modules of the UBS so they are not so dependent on each other.  For instance, home users who don't want to run the events scheduler at all should be able to do so with no hassle.
  Also, this code is very antiquated, and works by way of things being hardcoded.  A flexible events scheduling mechanism is planned to replace this.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "ubs-event.h"
#include "defaults.h"

/*+
  The main function.

  int main Returns OK on success

  int argc Should be empty; ignores all arguments

  char *argv[] Should be empty; ignores all arguments
+*/
int main(int argc, char *argv[])
{
 int i;

 // initialize the global table and such
 ubs_table_init(&GLOBAL);
 ubs_table_init(&EVENT);

 ubs_init(argv[0]);

 // initialize values specific to the event daemon
 ubs_table_add(&EVENT, "numevents", DEF_NUMEVENTS);

 if(read_config(DEF_CONFIG, "global", &GLOBAL)) {
  console_error("Can't read global settings in configuration file", FAIL);
 }
 // event specific context
 if(read_config(DEF_CONFIG, "event", &EVENT)) {
  console_error("Can't read event settings in configuration file", FAIL);
 }

 if(atoi(ubs_table_data(&EVENT, "numevents")) == 0) {
  console_error("Events parameter 'events.numevents' undefined", FAIL);
 }
 if(read_events(DEF_CONFIG)) {
  console_error("Error reading events from configuration file", FAIL);
 }

 if(check_running() == FAIL) {
  console_error("Daemon already seems to be running", FAIL);
 }

#ifndef WIN32
 log_error_msg(LOG_EMERG, "Process started as uid/gid %d/%d", geteuid(), getgid());
#else
 log_error_msg(LOG_EMERG, "Process started");
#endif

#ifndef WIN32
 // fork into the background
 if(fork()) {
  // parent exits
  exit(0);
 }
#endif

 log_error_msg(LOG_DEBUG, "Becoming the process leader");
 setsid();
 log_error_msg(LOG_DEBUG, "Changing root directory to PREFIX");
 chdir(ubs_table_data(&GLOBAL, "prefix"));
 log_error_msg(LOG_DEBUG, "Setting umask to 000");
 umask(0);

 record_pid(getpid());
 record_status("OK");

 while(1) {
  gettime();

  for(i = 0; i < atoi(ubs_table_data(&EVENT, "numevents")); i++) {
   if(CUR_TIME->tm_min == ALLEVENTS[i].mins) {
    if(ALLEVENTS[i].hrs > 0) {
     if(CUR_TIME->tm_hour == ALLEVENTS[i].hrs) {
      log_error_msg(LOG_DEBUG, "Preparing to exec event %d", i);
      run_event(i);
     }
    }
    else {
     log_error_msg(LOG_DEBUG, "Preparing to exec hourly event %d", i);
     run_event(i);
    }
   }
  }

  // sleep 1 minute and play it again, sam...
  sleep(60);
  record_status("OK");
 }
}
