/*    
	MsgCode.c	1.4
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


For more information about the Willows Twin Libraries.

	http://www.willows.com	

To send email to the maintainer of the Willows Twin Libraries.

	mailto:twin@willows.com 

 */


#include "windows.h"
#include "Log.h"
#include <stdio.h>

/* 
 * msgcode structure
 *	includes the msg number
 *	the message string
 *	the message opcode describes how to decode wparam,lparam
 *	an optional message counter
 */

MSGCODE msgcode[] = {
     { 0x0000,  "WM_NULL", 0,0	},
     { 0x0001,  "WM_CREATE", 0,0	},  
     { 0x0002,  "WM_DESTROY", 0,0	},
     { 0x0003,  "WM_MOVE", 0,0	},
     { 0x0004,  "WM_MOUSELEFTUP", 0,0	},
     { 0x0005,  "WM_SIZE", 0,0	},
     { 0x0006,  "WM_ACTIVATE", 0,0	},
     { 0x0007,  "WM_SETFOCUS", 0,0	},
     { 0x0008,  "WM_KILLFOCUS", 0,0	},
     { 0x000A,  "WM_ENABLE", 0,0	},
     { 0x000B,  "WM_SETREDRAW", 0,0	},
     { 0x000C,  "WM_SETTEXT", 0,0	},
     { 0x000D,  "WM_GETTEXT", 0,0	},
     { 0x000E,  "WM_GETTEXTLENGTH", 0,0	},
     { 0x000F,  "WM_PAINT", 0,0	},
     { 0x0010,  "WM_CLOSE", 0,0	},
     { 0x0011,  "WM_QUERYENDSESSION", 0,0	},
     { 0x0012,  "WM_QUIT", 0,0	},
     { 0x0013,  "WM_QUERYOPEN", 0,0	},
     { 0x0014,  "WM_ERASEBKGND", 0,0	},
     { 0x0015,  "WM_SYSCOLORCHANGE", 0,0	},
     { 0x0016,  "WM_ENDSESSION", 0,0	},
     { 0x0017,  "WM_SYSTEMERROR", 0,0	},
     { 0x0018,  "WM_SHOWWINDOW", 0,0	},
     { 0x0019,  "WM_CTLCOLOR", 0,0	},
     { 0x001A,  "WM_WININICHANGE", 0,0	},
     { 0x001B,  "WM_DEVMODECHANGE", 0,0	},
     { 0x001C,  "WM_ACTIVATEAPP", 0,0	},
     { 0x001D,  "WM_FONTCHANGE", 0,0	},
     { 0x001E,  "WM_TIMECHANGE", 0,0	},
     { 0x001F,  "WM_CANCELMODE", 0,0	},
     { 0x0020,  "WM_SETCURSOR", 0,0	},
     { 0x0021,  "WM_MOUSEACTIVATE", 0,0	},
     { 0x0022,  "WM_CHILDACTIVATE", 0,0	},
     { 0x0023,  "WM_QUEUESYNC", 0,0	},
     { 0x0024,  "WM_GETMINMAXINFO", 0,0	},
     { 0x0026,  "WM_PAINTICON", 0,0	},
     { 0x0027,  "WM_ICONERASEBKGND", 0,0	},
     { 0x0028,  "WM_NEXTDLGCTL", 0,0	},
     { 0x002A,  "WM_SPOOLERSTATUS", 0,0	},
     { 0x002B,  "WM_DRAWITEM", 0,0	},
     { 0x002C,  "WM_MEASUREITEM", 0,0	},
     { 0x002D,  "WM_DELETEITEM", 0,0	},
     { 0x002E,  "WM_VKEYTOITEM", 0,0	},
     { 0x002F,  "WM_CHARTOITEM", 0,0	},
     { 0x0030,  "WM_SETFONT", 0,0	},
     { 0x0031,  "WM_GETFONT", 0,0	},
     { 0x0035,  "WM_ISACTIVEICON", 0,0	},
     { 0x0037,  "WM_QUERYDRAGICON", 0,0	},
     { 0x0039,  "WM_COMPAREITEM", 0,0	},
     { 0x0041,  "WM_COMPACTING", 0,0	},
     { 0x0044,  "WM_COMMNOTIFY", 0,0	},
     { 0x0046,  "WM_WINDOWPOSCHANGING", 0,0	},
     { 0x0047,  "WM_WINDOWPOSCHANGED", 0,0	},
     { 0x0048,  "WM_POWER", 0,0	},
     { 0x0081,  "WM_NCCREATE", 0,0	},
     { 0x0082,  "WM_NCDESTROY", 0,0	},
     { 0x0083,  "WM_NCCALCSIZE", 0,0	},
     { 0x0084,  "WM_NCHITTEST", 0,0	},
     { 0x0085,  "WM_NCPAINT", 0,0	},
     { 0x0086,  "WM_NCACTIVATE", 0,0	},
     { 0x0087,  "WM_GETDLGCODE", 0,0	},
     { 0x0088,  "WM_SYNCPAINT", 0,0	},
     { 0x00A0,  "WM_NCMOUSEMOVE", 0,0	},
     { 0x00A1,  "WM_NCLBUTTONDOWN", 0,0	},
     { 0x00A2,  "WM_NCLBUTTONUP", 0,0	},
     { 0x00A3,  "WM_NCLBUTTONDBLCLK", 0,0	},
     { 0x00A4,  "WM_NCRBUTTONDOWN", 0,0	},
     { 0x00A5,  "WM_NCRBUTTONUP", 0,0	},
     { 0x00A6,  "WM_NCRBUTTONDBLCLK", 0,0	},
     { 0x00A7,  "WM_NCMBUTTONDOWN", 0,0	},
     { 0x00A8,  "WM_NCMBUTTONUP", 0,0	},
     { 0x00A9,  "WM_NCMBUTTONDBLCLK", 0,0	},
     { 0x0100,  "WM_KEYDOWN", 0,0	},
     { 0x0101,  "WM_KEYUP", 0,0	},
     { 0x0102,  "WM_CHAR", 0,0	},
     { 0x0103,  "WM_DEADCHAR", 0,0	},
     { 0x0104,  "WM_SYSKEYDOWN", 0,0	},
     { 0x0105,  "WM_SYSKEYUP", 0,0	},
     { 0x0106,  "WM_SYSCHAR", 0,0	},
     { 0x0107,  "WM_SYSDEADCHAR", 0,0	},
     { 0x0108,  "WM_KEYLAST", 0,0	},
     { 0x0110,  "WM_INITDIALOG", 0,0	},
     { 0x0111,  "WM_COMMAND", 0,0	},
     { 0x0112,  "WM_SYSCOMMAND", 0,0	},
     { 0x0113,  "WM_TIMER", 0,0	},
     { 0x0114,  "WM_HSCROLL", 0,0	},
     { 0x0115,  "WM_VSCROLL", 0,0	},
     { 0x0116,  "WM_INITMENU", 0,0	},
     { 0x0117,  "WM_INITMENUPOPUP", 0,0	},
     { 0x0118,  "WM_SYSTIMER", 0,0	},
     { 0x011F,  "WM_MENUSELECT", 0,0	},
     { 0x0120,  "WM_MENUCHAR", 0,0	},
     { 0x0121,  "WM_ENTERIDLE", 0,0	},


     { 0x0132,  "WM_CTLCOLORMSGBOX", 0,0},
     { 0x0133,  "WM_CTLCOLOREDIT",   0,0},         
     { 0x0134,  "WM_CTLCOLORLISTBOX",0,0},
     { 0x0135,	"WM_CTLCOLORBTN", 0,0   },
     { 0x0136,  "WM_CTLCOLORDLG",    0,0},          
     { 0x0137,  "WM_CTLCOLORSCROLLBAR", 0,0},    
     { 0x0138,  "WM_CTLCOLORSTATIC", 0,0},       

     { 0x0200,  "WM_MOUSEMOVE", 0,0	},
     { 0x0201,  "WM_LBUTTONDOWN", 0,0	},
     { 0x0202,  "WM_LBUTTONUP", 0,0	},
     { 0x0203,  "WM_LBUTTONDBLCLK", 0,0	},
     { 0x0204,  "WM_RBUTTONDOWN", 0,0	},
     { 0x0205,  "WM_RBUTTONUP", 0,0	},
     { 0x0206,  "WM_RBUTTONDBLCLK", 0,0	},
     { 0x0207,  "WM_MBUTTONDOWN", 0,0	},
     { 0x0208,  "WM_MBUTTONUP", 0,0	},
     { 0x0209,  "WM_MBUTTONDBLCLK", 0,0	},
     { 0x0210,  "WM_PARENTNOTIFY", 0,0	},
     { 0x0220,  "WM_MDICREATE", 0,0	},
     { 0x0221,  "WM_MDIDESTROY", 0,0	},
     { 0x0222,  "WM_MDIACTIVATE", 0,0	},
     { 0x0223,  "WM_MDIRESTORE", 0,0	},
     { 0x0224,  "WM_MDINEXT", 0,0	},
     { 0x0225,  "WM_MDIMAXIMIZE", 0,0	},
     { 0x0226,  "WM_MDITILE", 0,0	},
     { 0x0227,  "WM_MDICASCADE", 0,0	},
     { 0x0228,  "WM_MDIICONARRANGE", 0,0	},
     { 0x0229,  "WM_MDIGETACTIVE", 0,0	},
     { 0x0230,  "WM_MDISETMENU", 0,0	},
     { 0x0233,  "WM_DROPFILES", 0,0	},
     { 0x0300,  "WM_CUT", 0,0	},
     { 0x0301,  "WM_COPY", 0,0	},
     { 0x0302,  "WM_PASTE", 0,0	},
     { 0x0303,  "WM_CLEAR", 0,0	},
     { 0x0304,  "WM_UNDO", 0,0	},
     { 0x0305,  "WM_RENDERFORMAT", 0,0	},
     { 0x0306,  "WM_RENDERALLFORMATS", 0,0	},
     { 0x0307,  "WM_DESTROYCLIPBOARD", 0,0	},
     { 0x0308,  "WM_DRAWCLIPBOARD", 0,0	},
     { 0x0309,  "WM_PAINTCLIPBOARD", 0,0	},
     { 0x030A,  "WM_VSCROLLCLIPBOARD", 0,0	},
     { 0x030B,  "WM_SIZECLIPBOARD", 0,0	},
     { 0x030C,  "WM_ASKCBFORMATNAME", 0,0	},
     { 0x030D,  "WM_CHANGECBCHAIN", 0,0	},
     { 0x030E,  "WM_HSCROLLCLIPBOARD", 0,0	},
     { 0x030F,  "WM_QUERYNEWPALETTE", 0,0	},
     { 0x0310,  "WM_PALETTEISCHANGING", 0,0	},
     { 0x0311,  "WM_PALETTECHANGED", 0,0	},
     { 0x0380,  "WM_PENWINFIRST", 0,0	},
     { 0x038F,  "WM_PENWINLAST", 0,0	},
     { 0x0390,  "WM_COALESCE_FIRST", 0,0	},
     { 0x039F,  "WM_COALESCE_LAST", 0,0	},
     { 0x0400,  "WM_USER", 0,0	},
     { 0,0,0,0 }
};

/*
 * TODO
 * 	handle case where id == atom, as in registermessage
 */
char *
GetTwinMsgCode(HWND hWnd,int id)
{
	static char msgstr[132];
	char        msgbuf[132];
	MSGCODE *msgp;

	for(msgp=msgcode;msgp->msgstr;msgp++) {
		if(msgp->msgid == id)
			return msgp->msgstr;
	}
	
	if(id >= 0x400) {
		if(IsWindow(hWnd))
			GetClassName(hWnd,msgbuf,132);
		else	sprintf(msgbuf,"0x%x",id);
		sprintf(msgstr,"WM_USER+%d (%s)",id-0x400,msgbuf);
	} else
		sprintf(msgstr,"0x%x",id);

	return msgstr;
}

/* 
 * TODO
 * 	handle case where we can TURN off msgid's, and where we can 
 *	pass an alternative table to look through first
 */

void
LogTwinMsgCall(DWORD flag,MSGCODE *lp,HWND hWnd,int msg,WPARAM wParam,LPARAM lParam,char *function)
{
	char classname[256];
	GetClassName(hWnd,classname,256);
	LOGSTR((flag,"%s(HWND=%x(%s),MSG=%x(%s),WPARAM=%x,LPARAM=%x)\n",
		function,hWnd,classname,msg,GetTwinMsgCode(hWnd,msg),
		wParam,lParam));	
}

DWORD
LogTwinMsgRet(DWORD flag,DWORD rv,HWND hWnd,int msg,WPARAM wParam,LPARAM lParam,char *function)
{
	LOGSTR((flag,"%s(HWND=%x,MSG=%x,WPARAM=%x,LPARAM=%x) returns DWORD 0x%lx\n",
		function,hWnd,msg,wParam,lParam,rv));	
	return rv;
}

void
LogTwinMsgPtr(DWORD flag,MSGCODE *cp,LPMSG lpmsg,char *function)
{
	char classname[256];
	GetClassName(lpmsg->hwnd,classname,256);
	LOGSTR((flag,"[HWND=%x(%s),MSG=%x(%s),WPARAM=%x,LPARAM=%x] %s\n",
		lpmsg->hwnd,classname,lpmsg->message,
		GetTwinMsgCode(lpmsg->hwnd,lpmsg->message),
		lpmsg->wParam,lpmsg->lParam,function));	
}


