/****************************************************************************/
/*                                                                          */
/*  transmit.c - send blobs to/from TPM, with optional debugging            */
/*                                                                          */
/* This file is copyright 2003 IBM. See "License" for details               */
/****************************************************************************/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <tcpa.h>

/* optional verbose logging of data to/from tcpa chip */
static void showBlob(unsigned char *blob, char *string, FILE * tcpa_logfp)
{
    uint32_t i, len;

    if (!tcpa_logfp)
        return;
    len = ntohl(*(uint32_t *) & blob[TCPA_PARAMSIZE_OFFSET]);
    fprintf(tcpa_logfp, "        %s length=%d\n        ", string, len);
    for (i = 0; i < len; i++) {
        if (i && !(i % 16)) {
            fprintf(tcpa_logfp, "\n        ");
        }
        fprintf(tcpa_logfp, "%.2X ", blob[i]);
    }
    fprintf(tcpa_logfp, "\n");
    fflush(tcpa_logfp);
}

uint32_t TPM_Transmit(unsigned char *blob, FILE * log, char *msg)
{
    int tpmfp, len;
    uint32_t size, ret;

    if ((tpmfp = open("/dev/tpm", O_RDWR)) < 0) {
        fprintf(stderr, "Can't open TPM Driver\n");
        return -1;
    }
    if (log)
        fprintf(log, "    Entering %s\n", msg);
    showBlob(blob, "To TPM", log);
    size = ntohl(*(uint32_t *) & blob[TCPA_PARAMSIZE_OFFSET]);
    len = write(tpmfp, blob, size);
    if (len <= 0) {
        fprintf(stderr, "TPM write Error: %s\n", strerror(errno));
        close(tpmfp);
        return -1;
    }
    len = read(tpmfp, blob, TCPA_MAX_BUFF_SIZE);
    if (len <= 0) {
        fprintf(stderr, "TPM read Error: %s\n", strerror(errno));
        close(tpmfp);
        return -1;
    }
    showBlob(blob, "From TPM", log);
    ret = ntohl(*(uint32_t *) & blob[TCPA_RETURN_OFFSET]);
    close(tpmfp);
    if (log) {
        if (ret)
            fprintf(log, "    %s failed with error %d\n", msg, ret);
        else
            fprintf(log, "    %s succeeded\n", msg);
    }
    return (ret);
}
