/****************************************************************************/
/*                                                                          */
/*                      TCPA simple Demonstration Program                   */
/*                                                                          */
/*  This file is copyright 2003 IBM. See "License" for details              */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <tcpa.h>

int main(int argc, char *argv[])
{
    pubkeydata pubek;
    uint32_t slots;
    uint32_t pcrs;
    uint16_t num;
    uint32_t keys[256];
    unsigned char pcr_data[20];
    int major, minor, version, rev, i, j;

    if (TPM_Reset(TPMLOG))
        exit(-1);
    printf("TPM successfully reset\n");

    if (TPM_GetCapability_Version(&major,&minor,&version,&rev,TPMLOG))
        exit(-1);
    printf("TPM version %d.%d.%d.%d\n",major,minor,version,rev);

    if(TPM_GetCapability_Pcrs(&pcrs,TPMLOG))
        exit(-1);
    printf("%d PCR registers are available\n",pcrs);
    for(i=0;i<pcrs;i++){
        if(TPM_PcrRead((uint32_t)i,pcr_data,TPMLOG))
            exit(-1);
        printf("PCR-%02d: ",i);
        for(j=0;j<20;j++)
            printf("%02X ",pcr_data[j]);
        printf("\n");
    }

    if(TPM_GetCapability_Slots(&slots,TPMLOG))
        exit(-1);
    printf("%d Key slots are available\n",slots);

    if(TPM_GetCapability_Key_Handle(&num, keys, TPMLOG))
        exit(-1);
    if(num==0)
        printf("No keys are loaded\n");
    else 
        for(i=0;i<num;i++)
            printf("Key Handle %04X loaded\n",keys[i]);

    if (TPM_ReadPubek(&pubek, TPMLOG))
        exit(-1);

    return (0);
}
