/*
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <windows.h>
#include <winsock.h>

#include <stdlib.h>
#include <errno.h>

#include "buffer.h"
#include "stream5250.h"
#include "utility.h"
#include "displaybuf.h"
#include "formattable.h"
#include "codes5250.h"
#include "terminal.h"
#include "winterm.h"
#include "session.h"

char* remotehost;
char* transmapname = "en";
char* sessionname = "";
char port[50] = "23";

Session *sess;
Stream5250 *strm;
Terminal *term;

static void syntax (void);
static int parse_options (LPSTR lpszCmdLine);
static LPSTR parse_token (LPSTR * lpszScan);

// Windows entry point.
int WINAPI WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpszCmdLine,
        int nCmdShow)
{
   int cn_result;
   WSADATA wsadata;

   WSAStartup (0x0101, &wsadata);

   if (parse_options (lpszCmdLine)<0) {
      syntax ();
      exit (1);
   }

   if (WinTerminal::register_stuff (hInst) < 0) {
        //FIXME: A message would be nice.        
        exit (1);
   }

   settransmap(transmapname);

   term = new WinTerminal;
   term->init ();
   sess = new Session; 
   sess->terminal (term);
   strm = new Stream5250;
   cn_result = strm->Connect(remotehost, port, sessionname);
   if (cn_result != 0) {
      char msg[256];
      int ec = WSAGetLastError ();
      sprintf (msg, "Cannot connect to host: %d", ec);
      MessageBox (NULL, msg, "tn5250", MB_ICONEXCLAMATION);
      goto bomb_out;
   }
   
   term->connection_fd (strm->GetSocketHandle ());
   sess->stream (strm);
   sess->MainLoop ();

bomb_out:
   term->term();
   strm->Disconnect ();
   delete sess;
   if(cn_result != 0)
      printf("Could not start session: %s\n", strerror(cn_result));
#ifndef NDEBUG
   log_close ();
#endif
   WSACleanup ();
   return 0;
}

static int parse_options (LPSTR lpszCmdLine)
{
   int arg;
   bool have_port = false;
   LPSTR lpszToken;

   remotehost = NULL;

   while ((lpszToken = parse_token (&lpszCmdLine)) != NULL) {
        if (lpszToken[0] == '-' || lpszToken[0] == '/') {
                if (lstrlen (lpszToken) != 2)
                        return -1;
                switch (lpszToken[1]) {
                case 'm':
                        transmapname = parse_token (&lpszCmdLine);
                        if (transmapname == NULL)
                                return -1;
                        break;

                case 's':
                        sessionname = parse_token (&lpszCmdLine);
                        if (transmapname == NULL)
                                return -1;
                        break;

#ifndef NDEBUG
                case 't':
                        lpszToken = parse_token (&lpszCmdLine);
                        if (lpszToken == NULL)
                                return -1;
                        log_open (lpszToken);
                        break;
#endif
                default:
                        return -1;
                }
        } else {
                if (remotehost == NULL)
                        remotehost = lpszToken;
                else if (!have_port) {
                        have_port = true;
                        lstrcpyn (port, lpszToken, sizeof (port)-1);
                } else
                        return -1;
        }
   }

   if (remotehost == NULL)
        return -1;

   return 0;
}

// Get a token from the command line since Windows is too braindead to
// separate them itself.
static LPSTR parse_token (LPSTR *ppszScan)
{
        LPSTR pszScan = *ppszScan;
        LPSTR pszStart;

        while (*pszScan && isspace (*pszScan))
                pszScan ++;

        if (*pszScan == '\0')
                return NULL;

        pszStart = pszScan;
        if (*pszStart == '"') {
                pszStart = ++pszScan;
                while (*pszScan != '"' && *pszScan)
                        pszScan++;
		if (*pszScan)
			*pszScan++ = '\0';
        } else {
                while (!isspace (*pszScan) && *pszScan)
                        pszScan++;
		if (*pszScan)
			*pszScan++ = '\0';
        }
        *ppszScan = pszScan;
        return pszStart;
}

static void syntax ()
{
   MessageBox (NULL, "Usage:  tn5250 [options] <host> [port]\n"
      "Options:\n"
      "\t-m map      specify translation map\n"
      "\t-s name     specify session name\n"
#ifndef NDEBUG
      "\t-t file     specify trace file\n"
#endif
      , "tn5250", MB_ICONEXCLAMATION);
}
