/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef BUFFER_H
#define BUFFER_H

//
// Buffer class handles variable length binary data, including buffer
// reallocation.
//
class Buffer {
protected:
	unsigned char * data;
	int len;
	int allocated;

	void range_check (int idx) const;

public:
	Buffer ();
	Buffer (const Buffer& rhs);
	Buffer (unsigned char c);
	Buffer (unsigned char *newdata, int newlen);
	virtual ~Buffer ();

	int length () const;
	int length (int newlength);

	unsigned char at (int idx) const;
	unsigned char& at (int idx);

	Buffer& set (const Buffer& rhs);
	Buffer& set (unsigned char c);
	Buffer& set (unsigned char *newdata, int newlen);

	Buffer& append (const Buffer& rhs);
	Buffer& append (unsigned char c);
	Buffer& append (unsigned char *newdata, int newlen);

	int compare (const Buffer& rhs) const;

	inline unsigned char *get_data ()
	{
		return data;
	}

	inline const unsigned char *get_data () const
	{
		return data;
	}

	inline unsigned char operator [] (int idx) const
	{
		return at (idx);
	}

	inline unsigned char& operator [] (int idx)
	{
		return at (idx);
	}

	inline Buffer& operator = (const Buffer& rhs)
	{
		return set (rhs);
	}

	inline Buffer& operator = (unsigned char rhs)
	{
		return set (rhs);
	}

	inline Buffer& operator += (const Buffer& rhs)
	{
		return append (rhs);
	}

	inline Buffer& operator += (unsigned char rhs)
	{
		return append (rhs);
	}

	inline Buffer& operator + (const Buffer& rhs) const
	{
		Buffer b2(*this);
		return b2.append (rhs);
	}

	inline bool operator == (const Buffer& rhs)
	{
		return (compare (rhs) == 0);
	}

	inline bool operator >= (const Buffer& rhs)
	{
		return (compare (rhs) >= 0);
	}

	inline bool operator <= (const Buffer& rhs)
	{
		return (compare (rhs) <= 0);
	}

	inline bool operator != (const Buffer& rhs)
	{
		return (compare (rhs) != 0);
	}

	inline bool operator < (const Buffer& rhs)
	{
		return (compare (rhs) < 0);
	}

	inline bool operator > (const Buffer& rhs)
	{
		return (compare (rhs) > 0);
	}
};

#endif /* BUFFER_H */
