/*
 * $Id: tclshgdbm.c,v 1.1 2001/02/10 05:07:40 ellson Exp $
 */

#include "tcl.h"

/* variables */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;


/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tcl_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
    Tcl_Main(argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}


/*
 *--------------------------------------------------------------------
 *
 * Tcl_AppInit
 *
 *	Initialize Tcl and Clc und run the ~/.clcshrc startup file.
 *	The Name Tcl_AppInit is special - it is called by the
 *	main() procedure from the Tcl library.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *      message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *--------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;         /* Interpreter for application. */
{
    
    /*
     * initialize Tcl
     */
    
    if (Tcl_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

    /* 
     * initialize GDBM extension
     */

    if (Tclgdbm_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    Tcl_SetVar(interp, "tcl_rcFileName", "~/.tclgdbmrc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}
