/*
 * Copyright 2002 Christopher SEKIYA <wileyc@rezrov.net>
 * portions copyright 1997-2000 by Pawel Krawczyk <kravietz@ceti.pl>
 * Portions copyright 2000 by Jean-Louis Noel <jln@stben.be>
 *
 */

#if !defined(_TACSHELL_H)
#define _TACSHELL_H

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/signal.h>

#if defined(HAVE_STRING_H)
#include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#if defined(HAVE_MEMORY_H)
#include <memory.h>
#endif

#include "tacplus.h"

/* global defines */

#define MAX_SERVERS	10

/* global variables */

extern u_int32_t session_id;
extern int      tac_encryption;
extern char    *server_secret;
extern char    *user_shell;
extern u_int8_t sequence_number;
extern char    *challenge;

/* global prototypes */

int      tac_connect(u_int32_t);
void     tac_crypt(unsigned char *, struct tacacs_header *, int);
int      tac_check_header(struct tacacs_header *, int);
int      tac_authen_send(int, char *, char *);
int      tac_authen_read(int);
int      tac_authen_continue_send(int, char *);
void     parse_config(void);
void     cleanup(void);
u_int32_t       getservername(char *serv);
int 	authenticate(char *user);

#endif
