#ifndef DOXYGEN_H
#define DOXYGEN_H
/***************************************************************************
 *   Copyright (C) 2004, 2006 Symbian Software Ltd.                        *
 *   All rights reserved.                                                  *
 *   Copyright (C) 2007, 2008 Mike Kinghan, imk@strudl.org                 *
 *   All rights reserved.                                                  *
 *                                                                         *
 *   Contributed originally by Mike Kinghan, imk@strudl.org                *
 *                                                                         *
 *   Redistribution and use in source and binary forms, with or without    *
 *   modification, are permitted provided that the following conditions    *
 *   are met:                                                              *
 *                                                                         *
 *   Redistributions of source code must retain the above copyright        *
 *   notice, this list of conditions and the following disclaimer.         *
 *                                                                         *
 *   Redistributions in binary form must reproduce the above copyright     *
 *   notice, this list of conditions and the following disclaimer in the   *
 *   documentation and/or other materials provided with the distribution.  *
 *                                                                         *
 *   Neither the name of Symbian Software Ltd. nor the names of its        *
 *   contributors may be used to endorse or promote products derived from  *
 *   this software without specific prior written permission.              *
 *                                                                         *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   *
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     *
 *   LIMITED TO, THE IMPLIED WARRANTIES OF  MERCHANTABILITY AND FITNESS    *
 *   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE        *
 *   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,   *
 *   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  *
 *   BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS *
 *   OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED    *
 *   AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,*
 *   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF *
 *   THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH  *
 *   DAMAGE.                                                               *
 *                                                                         *
 ***************************************************************************/

/*!	\mainpage Sunifdef Maintainer's Documentation
 */

/*!	\file doxygen.h
	This file contains only Doxygen special comments blocks
 */

/*! \defgroup io_module The I/O module.
	This module controls the pairing of an input file or stream
	with an output file or stream and the line buffer through
	which they are connected.
*/

/*!\ingroup io_module
	\defgroup io_interface	The I/O module interface
 */

/*!\ingroup io_interface
	\defgroup io_interface_state_utils	Macro-generated code
	This code is generated by the macros in \c state_utils.h
 */

/*!\ingroup io_module
	\defgroup io_internals The I/O module internals
 */

/*!\ingroup io_internals
	\defgroup io_internals_state_utils	Macro-generated code
	This code is generated by the macros in \c state_utils.h
 */


/*! \defgroup report_module The Report module
	This module provides services for composing diagnostic
	messages and	codes.
*/

/*!\ingroup report_module
	\defgroup report_interface The Report module interface
	interface
 */

/*!\ingroup report_module
	\defgroup report_internals The Report module internals
	internals
 */

/*!\ingroup report_interface
	\defgroup report_interface_state_utils Macro-generated
	code.

	This code is generated by the macros in \c state_utils.h
 */

/*!\ingroup report_internals
	\defgroup report_internals_state_utils Macro-generated
	code.

	This code is generated by the macros in \c state_utils.h
 */

/*! \defgroup utils Utility modules
	This module provides utility services.
*/

/*!	\ingroup utils
	\defgroup ptr_vector_module The Pointer-Vector module.

	This module provides an elementary extensible array type to
	store pointers to heap objects.

	The type supports append and insert operations, but not
	delete.
	\note Extension of the vector causes reallocation of internal
	storage and invalidates pointers that are held to elements of
	the vector.
*/

/*!	\ingroup ptr_vector_module
	\defgroup ptr_vector_interface The Pointer-Vector module
	interface.
 */

/*!	\ingroup ptr_vector_module
	\defgroup ptr_vector_internals The Pointer-Vector module
	internals.
 */

/*!	\ingroup utils
	\defgroup state_utils The State Utilities module.
	This module provides apparatus mainly implemented in macros
	for defining a global state structure for a module \em M,
	and a public state structure within the global state that
	can be imported through the header file for \em M.

	It provides apparatus for querying and manipulating the
	global or public state of \em M, and for initialising and
	finalising the global state of \em M.

*/

/*! \ingroup state_utils
	\defgroup state_utils_interface	 The State Utilities
	interface.

	Because the State Utils are largely macro-based,
	state_utils.h imports a large number of scaffolding
	definitions as well as those that are expected to be useful.
	The scaffolding is documented for completeness in \ref
	state_utils_infrastructure. The useful macros are documented
	in \ref state_utils_user_macros.
*/

/*! \ingroup state_utils_interface
	\defgroup state_utils_user_macros State Utilities user
	macros.
 */

/*! \ingroup state_utils_user_macros
	\defgroup state_utils_hdr_macros Macros for the module header
	file.
 */

/*! \ingroup state_utils_user_macros
	\defgroup state_utils_impl_macros Macros for the module
	implementation file.
 */

/*! \ingroup state_utils_interface
	\defgroup state_utils_infrastructure State Utilities
	infrastructure.
 */


/*!	\ingroup utils
	\defgroup memory_module The Memory module.
	This module provides provides wrappers for \c malloc(),
	\c realloc() and \c calloc() that bail out on allocation
	failure.
*/

/*!\ingroup memory_module
	\defgroup memory_interface The Memory module interface.
 */

/*!	\ingroup memory_module
	\defgroup memory_internals The Memory module internals.
 */

/*! \defgroup symbol_table_module The Symbol Table module.
	This module controls the lookup table in which symbols given
	as arguments to the \c --define, \c --undefine
	options are	stored
*/

/*!\ingroup symbol_table_module
	\defgroup symbol_table_interface The Symbol Table module
	interface.

	The interface provides indexed access to elements in the
	symbol table and operations to find and add symbols.
 */

/*!\ingroup symbol_table_interface
	\defgroup symbol_table_interface_state_utils Macro-generated
	code.

	This code is generated by the macros in \c state_utils.h
*/

/*!\ingroup symbol_table_module
	\defgroup symbol_table_internals The Symbol Table module
	internals.
*/

/*!\ingroup symbol_table_internals
	\defgroup symbol_table_internals_state_utils Macro-generated
	code.

	This code is generated by the macros in \c state_utils.h
*/

/*! \defgroup args_module The Args module.
	This module controls the commandline options.
*/

/*!\ingroup args_module
	\defgroup args_interface The Args module interface.

	The interface provides acccess to the commandline arguments
	and operations to parse and analyse them.
*/

/*! \ingroup args_interface
	\defgroup args_interface_state_utils Macro-generated code.

	This code is generated by the macros in \c state_utils.h
*/

/*!\ingroup args_module
	\defgroup args_internals The Args module internals.
*/

/*! \ingroup args_internals
	\defgroup args_internals_state_utils Macro-generated code.

	This code is generated by the macros in \c state_utils.h
*/

 /*! \defgroup chew_module The Chew module.
	This module manages advancing of the text pointer over
	comments, whitespace and identifiers and the maintenance of
	state information about the text-pointer's context.
*/

/*!\ingroup chew_module
	\defgroup chew_interface The Chew module interface.
*/

/*!\ingroup chew_interface
	\defgroup chew_interface_state_utils Macro-generated code.

	This code is generated by the macros in \c state_utils.h
*/

/*!\ingroup chew_module
	\defgroup chew_internals The Chew module internals.
*/

/*!\ingroup chew_internals
 * \defgroup chew_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

 /*! \defgroup line_edit_module The Line Edit module
  *	This module provides routines for editing the line-buffer.
  */

/*!\ingroup line_edit_module
 * \defgroup line_edit_interface The Line Edit module interface
 */

/*!\ingroup line_edit_interface
 * \defgroup line_edit_interface_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

/*!\ingroup line_edit_module
 * \defgroup line_edit_internals The Line Edit module internals
 */

/*!\ingroup line_edit_internals
 * \defgroup line_edit_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

 /*! \defgroup line_despatch_module The Line Despatch module
  *	This module controls the final handling of an evaluated
  *	<tt>#</tt>-directive in the line-buffer. It is printed to
  *	output, or dropped, or replaced with a diagnostic insert.
  */

/*!\ingroup line_despatch_module
 * \defgroup line_despatch_interface The Line Despatch module interface
 */

/*!\ingroup line_despatch_interface
 * \defgroup line_despatch_interface_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */


/*!\ingroup line_despatch_module
 * \defgroup line_despatch_internals The Line Despatch module internals
 */

/*!\ingroup line_despatch_internals
 * \defgroup line_despatch_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

 /*! \defgroup if_control_module The #if-Control module
  *	This module manages the navigation of <tt>#if</tt>-directives.
  */

/*!\ingroup if_control_module
 * \defgroup if_control_interface The #if-Control module interface
 */

/*!	\ingroup if_control_module
 *	\defgroup if_control_internals The #if-Control module internals
 *
 *	The module is essentially a state machine. The implementation differs
 *	only trivially from that of
 *	<a href="http://dotat.at/prog/misc/unifdef.c">Tony Finch</a>
 *
 * A state transition function alters the global \c #if processing state
 * in a particular way. The state table is indexed by the current
 * processing state and the type of the current line.
 *
 * Nesting is handled by keeping a stack of states; some transition
 * functions increase or decrease the depth. In some complicated cases they have to
 * alter the preprocessor directive, as follows:
 *
 * When we have processed a group that starts off with a known false
 * \c #if/#elif sequence (which has therefore been deleted) followed by an
 * \c #elif that we cannot resolve and therefore must keep, we edit the
 * latter into a #if to keep the nesting correct.
 *
 * When we find a true \c #elif in a group, the following block will
 * always be kept and the rest of the sequence after the next \c #elif or
 * \c #else will be discarded. We edit the true \c #elif into an \c #else
 * and the following directive to \c #endif since this has the desired
 * behaviour.
 *
 * "Dodgy" directives are split across multiple lines, the most common
 * example being a multi-line comment hanging off the right of the
 * directive. We can handle them correctly only if there is no change
 * from printing to dropping (or vice versa) caused by that directive.
 * If the directive is the first of a group we have a choice between
 * failing with an error, or passing it through unchanged instead of
 * evaluating it. The latter is not the default to avoid user questions about
 * preprocessor directives being unexpectedly retained.
 */

/*!	\ingroup if_control_internals
 *	\defgroup if_control_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

/*!	\ingroup if_control_interface
 *	\defgroup if_control_interface_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

 /*! \defgroup categorical_module The Categorical module
  *	This module deals with the issue of categorical directives,
  *	specifically \c #define or \c #undef, that may echo or contradict the
  *	\c --define or \c --undefine options.
  *
  *	Categorical directives that echo \c --define or \c --undefine
  *	options are dropped.
  *
  *	Categorical directives that conflict with \c --define or \c --undefine
  *	options are handled according to the policy specified by the
  *	actual or default value of the \c --conflict option. The conflicting
  *	directive is either deleted, or replaced with a diagnostic comment,
  *	or a diagnostic \c #error directive.
  *
  *	Two sorts of conflict may arise:
  *	-	An \c #undef directive is read that contradicts a \c --define option
  *	-	A <tt>#define FOO [STRING]</tt> directive is read that conflicts
  *		with a <tt>--define FOO[=STRING]</tt> option by differently
  *		redfining \c FOO.
  *
  *	Handling conflicts of the first sort is aggravated by the precautionary
  * idiom:
  *
  *	<tt>#undef FOO<br>
  * ...Possibly comments...<br>
  * #define FOO [STRING]</tt><br>
  *
  *	When we have <tt>--define FOO[=STRING]</tt> we will detect a conflict
  *	on reading the \c #undef. But the conflict is going to be cancelled when
  *	we read the following \c #define, as long as it does not differently
  *	refine \c FOO. This possibility obliges us to save diagnostic information
  *	on reading the \c #undef and decide whether to use or discard it
  *	depending on what follows.
  */

/*!\ingroup categorical_module
 * \defgroup categorical_interface The Categorical module interface
 */

/*!\ingroup categorical_interface
 * \defgroup categorical_interface_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

/*!\ingroup categorical_module
 * \defgroup categorical_internals The Categorical module internals
 */

/*!\ingroup categorical_internals
 * \defgroup categorical_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

 /*! \defgroup evaluator_module The Evaluator module
	This module deals with the evaluation of input lines.

	Each line of input is evaluated to assign it a type.
	The type determines
	the action to be taken on the line and the state of the
	evaluator for the next line of input.
  */

/*!\ingroup evaluator_module
 * \defgroup evaluator_interface The Evaluator module interface
 */

/*!\ingroup evaluator_module
 * \defgroup evaluator_internals The Evaluator module internals
 */

/*!\ingroup evaluator_internals
 * \defgroup evaluator_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

/*!\ingroup evaluator_interface
 * \defgroup evaluator_interface_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
 */

 /*! \defgroup main_module The Main module
 *	This module implements the Sunifdef program
 */

 /*! \defgroup exception_module The Exception module
	This module provides a very rudimentary exception
	handling facility using \c setjmp() and \c longjmp().
	Exceptions are integer error codes. Throwing an exception
	can return execution to a point prior to the occurrence
	of the exception, where by testing the exception it
	can take an alternative course. It is not possible to
	re-throw an exception.
 */

/*! \defgroup filesystem_module The Filesystem module.
	This module provides an interface to filesystem operations
	that is neutral between Unix and Windows.
*/

/*!\ingroup filesystem_module
	\defgroup filesystem_interface The Filesystem module interface.
 */

/*!\ingroup filesystem_module
	\defgroup filesystem_unix The Filesystem module for Unix.
	Unix-specific implementations for the filesystem module.
 */

/*!\ingroup filesystem_unix
	\defgroup filesystem_unix_internals The Unix Filesystem module internals.
	Unix-specific internals of the filesystem module.
 */

/*!\ingroup filesystem_module
	\defgroup filesystem_windows The Filesystem module for Windows.
	Windows-specific implementations for the filesystem module.
 */

/*!\ingroup filesystem_windows
	\defgroup filesystem_windows_internals The Windows Filesystem module internals.
	Windows-specific internals of the filesystem module.
 */

/*! \defgroup file_tree_module The File Tree module.
	This module provides a data structure to represent a
	hierarchy of files and directories as organised in the
	file system and an API to query properties of the tree
	and to perform interative operations.
*/

/*! \ingroup file_tree_module
	\defgroup file_tree_interface The File Tree module interface.
*/

/*! \ingroup file_tree_module
	\defgroup file_tree_internals The File Tree module internals.
*/

/*! \defgroup dataset_module The Dataset module.
	This module provides a data structure to represent the
	the set files input to sunifdef, which can be a hierarchy
	including directories if the \c --recurse option is used.
	The module also holds the extension patterns given with
	the \c --filter option to select input files.

	The module thinly wraps the \e file_tree structure, exposing
	only operations to specify the filter patterns and to
	filter files within a given path into the dataset.
*/

/*! \ingroup dataset_module
	\defgroup dataset_interface The Dataset module interface.
*/

/*! \ingroup dataset_interface
	\defgroup dataset_interface_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
*/

/*! \ingroup dataset_module
	\defgroup dataset_internals The Dataset module interals.
*/

/*! \ingroup dataset_internals
	\defgroup dataset_internals_state_utils Macro-generated code
 *	This code is generated by the macros in \c state_utils.h
*/


#endif /* EOF */
