; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=wc3270
AppVerName=wc3270 3.3.12ga11
AppPublisher=Paul Mattes
AppPublisherURL=http://x3270.bgp.nu
AppSupportURL=http://x3270.bgp.nu
AppUpdatesURL=http://x3270.bgp.nu
AppCopyright=Copyright (C) 1989-2011 by Paul Mattes, GTRC and others
WizardSmallImageFile=x3270-icon2.bmp
DefaultDirName={pf}\wc3270
DisableDirPage=no
DefaultGroupName=wc3270
AllowNoIcons=yes
OutputBaseFilename=wc3270-3.3.12ga11-setup
OutputDir=.
Compression=lzma
SolidCompression=yes
ChangesAssociations=yes
MinVersion=4.0,5.0

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "insecure"; Description: "Install standard version"; GroupDescription: "Installation Type"; Flags: exclusive
Name: "secure"; Description: "Install secure version (requires separate OpenSSL library)"; GroupDescription: "Installation Type"; Flags: exclusive unchecked
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"

[Files]
Source: "wc3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: secure
Source: "wc3270-insecure.exe"; DestName: "wc3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: insecure
Source: "..\ws3270-3.3\ws3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: secure
Source: "..\ws3270-3.3\ws3270-insecure.exe"; DestName: "ws3270.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: insecure
Source: "..\wpr3287-3.3\wpr3287.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: secure
Source: "..\wpr3287-3.3\wpr3287-insecure.exe"; DestName: "wpr3287.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: insecure
Source: "catf.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "mkshort.exe"; DestDir: "{app}"; Flags: ignoreversion deleteafterinstall
Source: "ead3270.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "wc3270wiz.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: secure
Source: "wc3270wiz-insecure.exe"; DestName: "wc3270wiz.exe"; DestDir: "{app}"; Flags: ignoreversion; Tasks: insecure
Source: "x3270if.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "root_certs.txt"; DestDir: "{userappdata}\wc3270"; Flags: ignoreversion; Tasks: secure
Source: "html\Bugs.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\Build.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\FAQ.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\Intro.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\Keymap.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\Lineage.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\ReleaseNotes.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\Resources.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\README.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\SSL.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\wc3270-man.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "..\ws3270-3.3\html\ws3270-man.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "..\wpr3287-3.3\html\wpr3287-man.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\Wishlist.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "html\x3270if.html"; DestDir: "{app}\html"; Flags: ignoreversion
Source: "LICENSE.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "README.txt"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Dirs]
Name: "{userappdata}\wc3270";

[Code]
function myHelp(Param: String): String;
begin
; result := '/c start /b ' + GetShortName(ExpandConstant('{app}') + '\html\README.html');
 result := '/c start ' + GetShortName(ExpandConstant('{app}') + '\html\README.html');
end;

[Icons]
Name: "{group}\Session Wizard"; Filename: "{app}\wc3270wiz.exe"; WorkingDir: "{app}"
Name: "{group}\Run wc3270"; Filename: "{app}\wc3270.exe"; WorkingDir: "{app}"
Name: "{group}\wc3270 Documentation"; Filename: "{app}\html\README.html"
Name: "{group}\wc3270 Explore AppData"; Filename: "{app}\ead3270.exe"; Flags: runminimized; IconFilename: "{app}\wc3270.exe"

[Registry]
Root: HKCR; Subkey: ".wc3270"; ValueType: string; ValueName: ""; ValueData: "wc3270"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "wc3270"; ValueType: string; ValueName: ""; ValueData: "wc3270 Emulator Session"; Flags: uninsdeletekey
Root: HKCR; Subkey: "wc3270\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\wc3270.exe,0"
Root: HKCR; Subkey: "wc3270\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\wc3270"" ""%1"""

[Run]
Filename: "{app}\wc3270wiz.exe"; Description: "{cm:LaunchProgram,Session Wizard}"; Flags: nowait postinstall skipifsilent
Filename: "{cmd}"; Parameters: {code:MyHelp}; Description: "{cm:LaunchProgram,Online Documentation}"; Flags: nowait postinstall skipifsilent
Filename: "{app}\mkshort.exe"; Parameters: """{app}"" wc3270.exe ""wc3270"""; Flags: nowait skipifsilent runhidden; Tasks: desktopicon
Filename: "{app}\mkshort.exe"; Parameters: """{app}"" wc3270wiz.exe ""Session Wizard"""; Flags: nowait skipifsilent runhidden; Tasks: desktopicon
; Get rid of the old New wc3270 Session desktop icon.
Filename: "{cmd}"; Parameters: "/c erase ""{userdesktop}\New wc3270 Session.lnk"""; Tasks: desktopicon; Flags: runhidden; MinVersion: 0,4.0
Filename: "{cmd}"; Parameters: "/c erase ""{userdesktop}\New wc3270 Session.pif"""; Tasks: desktopicon; Flags: runhidden; MinVersion: 4.0,0
; Get rid of the old 'New wc3270 Session' start menu item.  It might be in
; the common programs group or the user programs group.
Filename: "{cmd}"; Parameters: "/c erase ""{commonprograms}\{groupname}\New wc3270 Session.lnk"""; Flags: runhidden
Filename: "{cmd}"; Parameters: "/c erase ""{userprograms}\{groupname}\New wc3270 Session.lnk"""; Flags: runhidden
; Get rid of the old DLLs.
Filename: "{cmd}"; Parameters: "/c erase ""{app}\w3n4.dll"""; Flags: runhidden
Filename: "{cmd}"; Parameters: "/c erase ""{app}\w3n46.dll"""; Flags: runhidden
Filename: "{cmd}"; Parameters: "/c erase ""{app}\shf.dll"""; Flags: runhidden

[UninstallRun]
Filename: "{cmd}"; Parameters: "/c erase ""{userdesktop}\wc3270.lnk"""; Tasks: desktopicon; Flags: runhidden; MinVersion: 0,4.0
Filename: "{cmd}"; Parameters: "/c erase ""{userdesktop}\Session Wizard.lnk"""; Tasks: desktopicon; Flags: runhidden; MinVersion: 0,4.0
Filename: "{cmd}"; Parameters: "/c erase ""{userdesktop}\wc3270.pif"""; Tasks: desktopicon; Flags: runhidden; MinVersion: 4.0,0
Filename: "{cmd}"; Parameters: "/c erase ""{userdesktop}\Session Wizard.pif"""; Tasks: desktopicon; Flags: runhidden; MinVersion: 4.0,0
