#!/bin/sh
#
# ssync.sh,v 1.4 2001/03/29 22:00:23 kim Exp
#
# Kimmo Suominen 1998-01-14, 1999-08-30
#
PATH=/usr/local/bin:/bin:/usr/bin:/usr/sbin:/usr/etc:/usr/ucb
PATH=${PATH}:@PREFIX@/bin:@PREFIX@/sbin
export PATH
#
netgroup="dist-`osname`-`uname -m`"
myname="`netname`"
servers="`netgroup $netgroup`"
any_servers="false"
destdir=
delete=
allmasters=
domain=`netname -d`
cwd=`@PAWD@`
RSH=rsh
# OPTS gets passed along via RSH in an 'ssync -A'
OPTS=
#
while [ "$1" != "" ]; do
	case "$1" in
	-[rR])	OPTS="$OPTS -R"
		delete="--delete"
		;;
	-y)	OPTS="$OPTS -y"
		rsyncopts="$rsyncopts --update"
		;;
	-v)	OPTS="$OPTS -v"
		rsyncopts="$rsyncopts --dry-run"
		;;
	-z)	OPTS="$OPTS -z"
		rsyncopts="$rsyncopts --compress"
		;;
	-f) 	OPTS="$OPTS $1 $2"
		if [ "$any_servers" = "false" ]; then
			any_servers="true"
			servers=""
		fi
		if [ ! -s $2 ]; then
			echo "$0: No file $2" 2>&1
			exit 1
		fi
		for i in `cat $2`
		do
			x=`netgroup $i`
			case "$x" in
			'')	# Must be a hostname
				x=$i
				;;
			*)	# Aha, was a netgroup after all
				;;
			esac
			servers="$servers $x"
		done
		shift
		;;
	-h) 	OPTS="$OPTS $1 $2"
		if [ "$any_servers" = "false" ]; then
			any_servers="true"
			servers=""
		fi
		x=`netgroup $2`
		case "$x" in
		'')	# Must be a hostname
			x=$2
			;;
		*)	# Aha, was a netgroup after all
			;;
		esac
		servers="$servers $x"
		shift
		;;
	-A)	# Don't propagate -A
		remote=`netgroup $netgroup-masters`
		servers="$servers $remote"

		if [ -z "$remote" ]
		then
			echo "$0: No netgroup $netgroup-masters" 2>&1
			exit 1
		fi
		# pull current domain out of list of domains-to-push-to
		allmasters=
		for i in $remote
		do
			if [ "`netname -d $i`" = $domain ]
			then
				:
			else
				allmasters="$allmasters $i"
			fi
		done
		;;
	-D)	OPTS="$OPTS $1 $2"
		destdir=$2
		shift
		;;
	-[sS])	OPTS="$OPTS $1"
		RSYNC_RSH=srsh export RSYNC_RSH
		RSH=ssh
		;;
	*)      break
		;;
	esac
	shift
done

if [ -z "$servers" ]
then
	echo "$0: No netgroup $netgroup to get default servers" 1>&2
	exit 1
fi

x=
for i in $servers
do
	case $i in
	$myname)
		;;
	*)
		x="$x $i"
		;;
	esac
done
servers="$x"
if [ -z "$servers" ]
then
	echo "$0: No hosts to update (apparently just myself)" 1>&2
	exit 1
fi

case $# in
0)	set x $cwd; shift;;
esac

for directory
do
	case "$destdir" in
	'')	case "$directory" in
		/*)	;;
		*)	directory="$cwd/$directory";;
		esac
		;;
	*)	;;
	esac
	dirs="$dirs $directory"
done

# Construct the rsync command resembling rdist behaviour.
for i in $servers
do
	echo "Updating $i"
	for j in $dirs
	do
		echo "+ $j"
		if [ -d $j ]
		then
			k="$delete $j/"
		else
			k="$j"
		fi
		rsync -aH $rsyncopts $k $i:${destdir:-$j}
	done
done

if [ ! -z "$allmasters" ]
then
	for i in $allmasters
	do
		echo "Initiatiating remote updates to $i"
		$RSH -n $i "ssync $OPTS $dirs" || exit $?
	done
	wait
fi

exit 0
