// debug.h - debugging routines
#ifndef _DEBUGGING_PROTOTYPES
#define _DEBUGGING_PROTOTYPES

#ifdef PROTO_DEBUG
        
const unsigned int DEFAULT_DEBUG_LEVEL = 0;

void SetDebugLevel(unsigned int level);
unsigned int DebugLevel();

bool OpenDebugLog(const char *path);
void CloseDebugLog();

void DMSG(unsigned int level, const char *format, ...);

void ABORT(const char *format, ...);

#ifdef HAVE_ASSERT
#include <assert.h>
#ifndef ASSERT
#define ASSERT(X) assert(X)
#endif // ASSERT
#else
#define ASSERT(X) (X ? : ABORT("ASSERT(%s) failed at line %d in source file \"%s\"\n", \
			#X, __LINE__, __FILE__ ));
#endif // HAVE_ASSERT

#ifdef TRACE
#undef TRACE
#endif // TRACE
void TRACE(const char *format, ...);

#else  // non-debug

#ifndef TRACE
inline void TRACE(const char *format, ...) {}
#endif // !TRACE

inline void DMSG(unsigned int level, const char *format, ...) {}

#ifndef ASSERT
#define ASSERT(X)
#endif // !ASSERT 

#ifndef ABORT
#define ABORT(X)
#endif // !ABORT

#endif // if/else PROTO_DEBUG

#ifdef WIN32
void OpenDebugWindow();
void CloseDebugWindow();
#endif // WIN32

#endif // _DEBUGGING_PROTOTYPES
