# MDPv2 Client Dialog Window
# Written by Joe Macker & Brian Adamson 1998
#
# Set up background/foreground according to display
# capability (B/W or Color)
set screenDepth [winfo screendepth .]
case $screenDepth in { 
    1 {
		set activeBgColor     black
		set activeFgColor     white
		set disabledFgColor   ""
		set selectBgColor     black
		set selectFgColor     white
		set BgColor           black
		set FgColor           white
	}
    default {
		set activeBgColor     black
		set activeFgColor     "light gray"
		set disabledFgColor   ""
		set selectBgColor     "light gray"
		set selectFgColor     black
		set BgColor           "light gray"
		set FgColor           black
	}
}
 
option add *activeBackground          $activeBgColor          startupFile
option add *activeForeground          $activeFgColor          startupFile
option add *CheckButton.selector      $FgColor                startupFile
option add *background                $BgColor                startupFile
option add *foreground                $FgColor                startupFile
option add *selectBackground          $selectBgColor          startupFile
option add *Scale.activeForeground    $activeBgColor          startupFile
option add *Scale.sliderForeground    $BgColor                startupFile
option add *Scrollbar.foreground      $BgColor                startupFile
option add *Scrollbar.activeForeground  $activeBgColor        startupFile
option add *Button.disabledForeground $disabledFgColor        startupFile

# redefine the exit procedure
rename exit exit.old
proc exit {status} {
    shutdown
    exit.old $status
}

proc InitMdpMainWindow {version session} {
	
    wm title . "$session"
    wm iconbitmap . "mdp_logo"
	wm iconname . "MDPv2 Client"
	set locktransmit 0
	wm protocol . WM_DELETE_WINDOW {exit 0}
	
	set widthtext 40
	
	# "w" may actually be used for something some day
	set w ""

	# Create the main window menu bar
	frame $w.menu -relief raised -bd 2
	pack $w.menu -side top -fill x

	# Create the menus
	set m $w.menu.file.m
	menubutton $w.menu.file -text "File" -menu $m -underline 0
	menu $m
	$m add command -label "Exit" -command shutdown -underline 1

	set m $w.menu.options.m
	menubutton $w.menu.options -text "Settings" -menu $m -underline 0
	menu $m
	$m add command -label "Debug Level ..." -command "setDebug" -underline 0
	$m add command -label "Post Processor ..." -command "setPostProc" -underline 0
    set presentdir "/tmp"
	$m add command -label "Archive Directory ..." -command "SelectDir . $presentdir" -underline 0

	set m $w.menu.help.m
	menubutton $w.menu.help -text "Help" -menu $m -underline 0
	menu $m
	$m add command -label "About MDPv2 ..." -command "ShowInfoDlg . $version"

	#.frame1 (Contains progress meter)
	frame $w.frame1 -borderwidth 5
	canvas $w.frame1.meter  -width 230 -height 30 -bd 3 -highlightthickness 0

	# add a ruler frame for progress meter use
	$w.frame1.meter create rect 15 15 215 25 -fill "#00cfff"
	$w.frame1.meter create line 15 20 15 20  -fill blue -width 10 -tags line

	#.frame2 (Contains status label)
	frame $w.frame2 -borderwidth 5
	label $w.frame2.label -width $widthtext -text "Waiting for transmission ..."

	pack append $w.frame1 $w.frame1.meter {top} $w.frame1.meter {bottom}
	pack append $w.frame2 $w.frame2.label {top} $w.frame2.label {bottom}
	pack $w.menu.file $w.menu.options $w.menu.help -side left -expand 1
	pack $w.menu $w.frame1 $w.frame2 -expand 1 -fill both	
}  

proc SetMdpProgressMeter {percent} {
	#Convert "percent" to corresponding meter "width"
	set width [expr $percent * 2 + 15] 
    .frame1.meter coords line 15 20 $width 20
}	

proc SetMdpStatusText {theText} {
    .frame2.label config -text $theText
}

proc ShowInfoDlg {w version} {
	mkDialog .info  \
	 	"-text \
{Naval Research Laboratory (NRL) MDPv2 Client version $version\n\
\tby Joe Macker and Brian Adamson.\n\n\
This program is part of the prototype NRL MDP software release.  The \
latest release is available at <http://manimac.itd.nrl.navy.mil/MDP>\
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR \
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED \
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR \
PURPOSE.  Please include this notice and provide credit to the \
authors and NRL if this program or parts of it are used for any \
purpose.\n\n\
We would appreciate receiving any contributed enhancements \
or modifications to this code release. Please contact the developers \
with comments and questions.  Feedback on use of this code can help \
continue support for further development.\n\n\
Joe Macker                     \t\tBrian Adamson \n\
Email: <macker@itd.nrl.navy.mil> \t<adamson@itd.nrl.navy.mil> \n\
Telephone: +1-202-767-2001       \t+1-202-404-1194 \n\
Naval Research Laboratory        \tNewlink Global Engineering Corp. \n\
Information Technology Division  \t8580 Cinder Bed Road, Suite 1000 \n\
4555 Overlook Avenue, S.W.       \tNewington, VA 22122 \n\
Washington DC 20375              \t<http://www.ngec.com> } \
        -justify left -font {-size 12} -aspect 200" \
        "OK {}"
    wm title .info "About MDPv2 ..."
}                     
proc SelectDir {w presentdir} {
	mkDialog .dirselect  \
	 	"-text {Under Construction} -aspect 600 " \
		"OK {}" 
    wm title .dirselect "MDP Archive directory ..."
} 

proc UpdateDebugLevel {w} {
    SetDebugLevel [$w.frame.ent get]
    destroy $w
}

proc setDebug {{w .debugwin}} {
    catch {destroy $w}
    toplevel $w
    wm title $w "MDP Debug level ..."
    wm iconname $w "MDP Debug Level"
    wm minsize $w 1 1
    frame $w.frame -borderwidth 10
    label $w.frame.label -text "Enter debug level (0-12):"
    entry $w.frame.ent -width 4 
    $w.frame.ent insert 0 [GetDebugLevel]
    frame $w.frame.ok -borderwidth 2 -relief sunken
    button $w.frame.ok.b -text "OK" -command "UpdateDebugLevel $w"
    bind $w <Return> "UpdateDebugLevel $w" 
    pack $w.frame.ok.b -padx 3 -pady 3
    pack $w.frame $w.frame.label $w.frame.ent -side left
    pack $w.frame.ok -side bottom  -padx 5
}

proc UpdatePostProcessor {w} {
    SetPostProcessor [$w.frame.ent get]
    destroy $w
}

proc setPostProc {{w .postprocwin}} {
    catch {destroy $w}
    set oldFocus [focus]
    toplevel $w
    wm title $w "MDP Post Processor ..."
    wm iconname $w "MDP Post Processor"
    wm minsize $w 1 1
    frame $w.frame -borderwidth 10
    label $w.frame.label -text "Enter post processor command:"
    entry $w.frame.ent -width 32 
    $w.frame.ent insert 0 [GetPostProcessor]
    frame $w.frame.ok -borderwidth 2 -relief sunken
    button $w.frame.ok.b -text "OK" -command "UpdatePostProcessor $w"
    bind $w <Return> "UpdatePostProcessor $w"    
    button $w.frame.cancel -text "Cancel" \
        -command "catch {destroy $w}; focus $oldFocus"
    pack $w.frame.ok.b -padx 3 -pady 3        
    pack $w.frame $w.frame.label $w.frame.ent -side top -anchor w
    pack $w.frame.cancel $w.frame.ok -side right -anchor e -padx 5 -pady 5
    
}



# Create a dialog box.  Takes three or more arguments.  The first is
# the name of the window to use for the dialog box.  The second is a set
# of arguments for use in creating the message of the dialog box.  The
# third and following arguments consist of two-element lists, each
# describing one button.  The first element gives the text to be displayed
# in the button, the second gives the command to be invoked when the
# button is invoked.
proc mkDialog {w msgArgs args} {
    catch {destroy $w}
    toplevel $w -class Dialog
    set oldFocus [focus]
 
# Create two frames in the main window. The top frame will hold the
# message and the bottom one will hold the buttons.  Arrange them
# one above the other, with any extra vertical space split between
# them.
    frame $w.top -relief raised -border 1
    frame $w.bot -relief raised -border 1
    pack append $w $w.top {top fill expand} $w.bot {top fill expand}
    
# Create the message widget and arrange for it to be centered in the
# top frame.
    eval message $w.top.msg -justify center \
          -font -Adobe-times-medium-r-normal--*-180* $msgArgs
    pack append $w.top $w.top.msg {top expand padx 5 pady 5}
    
# Create as many buttons as needed and arrange them from left to right
# in the bottom frame.  Embed the left button in an additional sunken
# frame to indicate that it is the default button, and arrange for that
# button to be invoked as the default action for clicks and returns in
# the dialog.
 
    if {[llength $args] > 0} {
		set arg [lindex $args 0]
		frame $w.bot.0 -relief sunken -border 1
		pack append $w.bot $w.bot.0 {left expand padx 20 pady 20}
		button $w.bot.0.button -text [lindex $arg 0] \
    		  -command "[lindex $arg 1]; catch {destroy $w}; focus $oldFocus"
		pack append $w.bot.0 $w.bot.0.button {expand padx 12 pady 12}
		bind $w <1> "$w.bot.0.button config -relief sunken"
		bind $w <ButtonRelease-1> \
    		  "catch {destroy $w}; focus $oldFocus"
		bind $w <Return> "[lindex $arg 1]; catch {destroy $w}; focus $oldFocus"
		focus $w

		set i 1
		foreach arg [lrange $args 1 end] {
		  button $w.bot.$i -text [lindex $arg 0] \
        		  -command "[lindex $arg 1];focus $oldFocus"
		#                  -command "[lindex $arg 1]; catch {destroy $w}; focus $oldFocus"
		  pack append $w.bot $w.bot.$i {left expand padx 20}
		  set i [expr $i+1]
		}
	}
}





















