/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/

#ifndef _TK_MDP
#define _TK_MDP

#include <tk.h>
#include <string.h>

#include "mdpApp.h"
#include "postProcess.h"

#ifdef LINUX
typedef void (*SignalHandlerFunc)(int);
#else
typedef void (*SignalHandlerFunc)(...);
#endif // LINUX

class TkMdpApp : public MdpApp
{
    
    public:
    // Methods
        TkMdpApp();
        ~TkMdpApp();
        
        void StartTxIntervalTimer(double delay);     
        void StopTxIntervalTimer();
        
        void SetInterpreter(Tcl_Interp *theInterp)
			{interp = theInterp;}
		
        void Run() {Tk_MainLoop();}
  
        void SetPostProcessor(char* theCmd);
        void KillPostProcessor();
        void CheckForNetscape();
        void SetNetscape(bool value) {use_netscape = value;}
        void OnExit();
        
        
        // Some static functions
        static int GetDebugLevel(ClientData  clientData,
                                 Tcl_Interp* interp,
                                 int argc, char *argv[]);
        static int SetDebugLevel(ClientData  clientData,
                                 Tcl_Interp* interp,
                                 int argc, char *argv[]);
        static int GetPostProcessor(ClientData  clientData,
                                    Tcl_Interp* interp,
                                    int argc, char *argv[]);
        static int SetPostProcessor(ClientData  clientData,
                                    Tcl_Interp* interp,
                                    int argc, char *argv[]);
        
        static int DoShutdown(ClientData clientData,
                              Tcl_Interp* interp,
                              int argc, char** argv);
        
        static bool MdpTimerInstaller(MdpTimerInstallCmd    cmd, 
                                      double                delay,
                                      MdpTimerHandle        timerHandle, 
                                      MdpInstanceHandle     instanceHandle);
        
        static bool MdpSocketInstaller(MdpSocketInstallCmd  cmd,
                                       MdpSocketHandle      socketHandle,
                                       MdpInstanceHandle    instanceHandle);
        bool InstallSignalHandler(int signum);
        void RemoveSignalHandler(int signum);
        static void SignalHandler(int signum);
        static int SafeSIGCHLDHandler(ClientData     clientData,
                                      Tcl_Interp*    interp,
                                      int            code);
        static int SafeSIGINTHandler(ClientData     clientData,
                                     Tcl_Interp*    interp,
                                     int            code);
        private:
        // Members
            Tcl_Interp*     interp;
            Window          window_id;
            bool            use_netscape;
            Tcl_TimerToken  tx_interval_timer_id;
            int             post_processor_id;
            
            static Tcl_AsyncHandler SIGCHLD_token;
            static Tcl_AsyncHandler SIGINT_token;
          
        // Methods
            void SetStatusText(const char* theText);
            void SetProgressMeter(unsigned int percent);
            void PostProcess(const char* path);
            
            static void DoTxIntervalTimeout(ClientData data);
            static void MdpSocketHandler(ClientData data, int mask);
            static void MdpTimerHandler(ClientData data);
};

#endif // _TK_MDP
