#!/usr/bin/tclsh

# Runs ns simplemdp.tcl for Nack stats vs. group size

set sizeList {500 600 700 800 900 1000}

set rate 32kb
set duration 92.0

set fileName "suppress25.gp"

exec rm -f $fileName

set outFile [open $fileName "w"]

# Gnuplot header
puts $outFile "set title 'NACK Suppression Performance'"
puts $outFile "set data style lines"
puts $outFile "set xlabel 'Number of Receivers'"
puts $outFile "set ylabel 'NACK Transmission Fraction'"
puts $outFile "plot \\"
puts $outFile "'-' using 1:2 \\"
puts $outFile "'Receivers:%lf alpha:%lf' t 'Theoretical Multicast NACKs', \\"
puts $outFile "'-' using 1:2 \\"
puts $outFile "'Receivers:%lf alpha:%lf' t 'Theoretical Unicast NACKs', \\"
puts $outFile "'-' using 1:(\$4) \\"
puts $outFile "'Receivers:%lf Sent:%lf Suppressed:%lf alpha:%lf' t 'Measured Unicast NACKs', \\"
puts $outFile "'-' using 1:(\$4) \\"
puts $outFile "'Receivers:%lf Sent:%lf Suppressed:%lf alpha:%lf' t 'Measured Multicast NACKs'\n"

puts "Computing theoretical results ..."
# T = number of GRTT for NACK backoff timers ...
set T 3.0
# Theoretical Multicast NACK results
puts $outFile "#Theoretical Multicast NACK Suppression Factor (alpha)"
foreach numClient $sizeList {
    set lambda [expr log($numClient) + 1.0]
    set N [expr exp((1.2/(2.0 * $T)) * ($lambda))]
    set alpha [expr $N / $numClient]
    puts $outFile "Receivers:$numClient alpha:$alpha" 
}  
puts $outFile "e\n"
# Theoretical Unicast NACK results
puts $outFile "#Theoretical Unicast NACK Suppression Factor (alpha)"
foreach numClient $sizeList {
    set lambda [expr log($numClient) + 1.0]
    set N [expr exp((1.2/(1.0 * $T)) * ($lambda))]
    set alpha [expr $N / $numClient]
    puts $outFile "Receivers:$numClient alpha:$alpha" 
} 
close $outFile


# Measured Unicast NACK results
set outFile [open $fileName "a"]
puts $outFile "e\n"
puts $outFile "#Measured Unicast NACK Suppression Factor (alpha)"
close $outFile
#set sizeList {10 100} 
foreach numClient $sizeList {
    puts "Starting simulation run (groupSize:$numClient) ..."
    puts "   ns simplemdp.tcl $numClient $rate $duration unicastNacks"
    catch {eval exec ns simplemdp.tcl $numClient $rate $duration unicastNacks}
    puts "   nc mdpLog.txt >> $fileName"        
    catch {eval exec nc mdpLog.txt >> $fileName}
}


# Measured Multicast NACK results
set outFile [open $fileName "a"]
puts $outFile "e\n"
puts $outFile "#Measured Multicast NACK Suppression Factor (alpha)"
close $outFile 
foreach numClient $sizeList {
    puts "Starting simulation run (groupSize:$numClient) ..."
    puts "   ns simplemdp.tcl $numClient $rate $duration"
    catch {eval exec ns simplemdp.tcl $numClient $rate $duration}
    puts "   nc mdpLog.txt >> $fileName"        
    catch {eval exec nc mdpLog.txt >> $fileName}
}

puts "Finished."
