#
proc Usage {} {
    puts {Usage: "ns mdpvstcp.tcl [<numMdp> <numTcp> <bottleneckRate> <duration> <window> [fast]]"}
}        


proc MDPvsTCP {numMDP numTCP bottleneckRate duration window fast} {


set show_tcphdr 1

# Create multicast enabled simulator ins__tance
set ns_ [new Simulator -multicast on]
$ns_ multicast

# Turn on full ns_/NAM tracing
set f [open out-mcast.tr w]
$ns_ trace-all $f
set nf [open out-mcast.nam w]
$ns_ namtrace-all $nf

$ns_ color 0 red
$ns_ color 2 black
$ns_ color 1 blue

# Set up color mapping for MDPv2 packet types
$ns_ color 41 yellow
$ns_ color 42 blue
$ns_ color 43 darkgreen
$ns_ color 44 purple
$ns_ color 45 orange
$ns_ color 46 red
$ns_ color 47 black

# Create 16 nodes (7 sources, 2 on bottleneck, 7 sinks)
for {set i 0} {$i < 16} {incr i} {
    set n($i) [$ns_ node]
	}

# Make 7 source links 
set angle 1.55
for {set i 0} {$i < 7} {incr i} {
    $ns_ duplex-link $n($i) $n(7) 10Mb 1ms DropTail
    $ns_ queue-limit $n($i) $n(7) 100
    $ns_ duplex-link-op $n($i) $n(7) orient $angle
    $ns_ duplex-link-op $n($i) $n(7) queuePos 0.5
    set angle [expr $angle + 0.15]
    }

# Make 1 bottleneck link (Node 7 -> Node 8 link)
$ns_ duplex-link $n(7) $n(8) $bottleneckRate 10ms DropTail
$ns_ queue-limit $n(7) $n(8) 80
$ns_ duplex-link-op $n(7) $n(8) orient right
$ns_ duplex-link-op $n(7) $n(8) queuePos 0.5

# Make 7 sink links (fanout)
set angle 0.45
for {set i 9} {$i < 16} {incr i} {
    $ns_ duplex-link $n(8) $n($i) 10Mb 1ms DropTail
    $ns_ queue-limit $n(8) $n($i) 100
	$ns_ duplex-link-op $n(8) $n($i) orient $angle
    $ns_ duplex-link-op $n(8) $n($i) queuePos 0.5
    set angle [expr $angle - 0.15]  
    if {$angle < 0.0} {
        set angle 1.85
        }
    }
    
### Start multicast configuration: 5 mproto options_
### CtrMcast   : centralized multicast
### DM         : static DVMRP (can't adapt to link up/down or node up/down)
### detailedDM : dens_e mode protocol that adapts to dynamics (recommended)
### dynamicDM  : dynamic DVMRP 
### pimDM      : PIM dens_e mode

### Uncomment following lines to change default
#DM set PruneTimeout 0.3               ;# default 0.5 (sec)
#dynamicDM set ReportRouteTimeout 0.5  ;# default 1 (sec)

set mproto DM
set mrthandle [$ns_ mrtproto $mproto  {}]
if {$mrthandle != ""} {
    $mrthandle set_c_rp [list $n(3)]
}
### End of multicast configuration


# Create loss modules for bottleneck and sink fanout links
for {set i 8} {$i < 16} {incr i} {
	set em($i) [new ErrorModel]
	$em($i) set rate_ 0.0
	$em($i) unit pkt
	$em($i) ranvar [new RandomVariable/Uniform]
    $em($i) drop-target [new Agent/Null]
	}

# Assign loss modules to interesting links
# Bottleneck link
$ns_ lossmodel $em(8) $n(7) $n(8)
$em(8) set rate_ 0.00
# Fanout links
for {set i 9} {$i < 16} {incr i} {
    $ns_ lossmodel $em($i) $n(8) $n($i)
    $em($i) set rate_ 0.0
    }

#########################################
# Create FTP/TCP source and sink agents
# Create TCP first so filtering to rateplot works ..Joe 4/99
#set numTCP 7
for {set i 0} {$i < $numTCP} {incr i} {
# Which node (0-6) is this connection associated with?
    set k $i
    if {$k > 6} {
        set k 0
        }

# Source
    set tcp_src($i) [new Agent/TCP/FullTcp]
    $ns_ attach-agent $n($k) $tcp_src($i)
    $tcp_src($i) set window_ 100
    $tcp_src($i) set packetSize_ 512

# Sink
    set tcp_sink($i) [new Agent/TCP/FullTcp]
    $ns_ attach-agent $n([expr $k + 9]) $tcp_sink($i)
    $ns_ connect $tcp_src($i) $tcp_sink($i)
    $tcp_sink($i) listen

# FTP App
    set ftp($i) [new Application/FTP]
    $ftp($i) attach-agent $tcp_src($i)
    }
    
#######################################  
# Create MDPv2 server and client Agents
#set numMDP 7
for {set i 0} {$i < $numMDP} {incr i} {
# Which node (0-6) is this connection associated with?
    set k $i
    if {$k > 6} {
        set k 0
        }
# Server side agent (Node k)
    set mdp_server($i) [new Agent/MDP]
    $ns_ attach-agent $n($k) $mdp_server($i)
    $mdp_server($i) ttl 32
    $mdp_server($i) txRate 32000
    $mdp_server($i) segmentSize 512
    $mdp_server($i) blockSize 20
    $mdp_server($i) numParity 20
    $mdp_server($i) autoParity 0
    $mdp_server($i) numRepeats -1
    $mdp_server($i) congestionControl on
    $mdp_server($i) fastStart $fast
    $mdp_server($i) colorPackets on
#    $mdp_server($i) sendLoss 0.0
    
# Client side agent (Node k)
    set mdp_client($i) [new Agent/MDP]
    $ns_ attach-agent $n([expr $k + 9]) $mdp_client($i)
    #$mdp_client($i) ecnEnable on
    $mdp_client($i) colorPackets on
}

# Global MDPv2 settings
if {$numMDP > 0} {
    $mdp_server(0) debugLevel 2
    #$mdp_server(0) messageTrace on
    $mdp_server(0) logFile mdpLog.txt
    }
    
    
# Run MDPv2 and TCP over topology

# Start MDPv2 servers and clients
set group [Node allocaddr]
for {set i 0} {$i < $numMDP} {incr i} {
    $ns_ at 0.0 "$mdp_server($i) start server $group"
    $ns_ at 0.0 "$mdp_server($i) send 65535"
    $ns_ at 0.0 "$mdp_client($i) start client $group"
    set group [Node allocaddr]
    }

   
# Start FTP sessions_
for {set i 0} {$i < $numTCP} {incr i} {
    $ns_ at 0.0 "$ftp($i) start"
    }

set filename $numMDP
append filename "mdp_vs_" $numTCP "tcp_" $bottleneckRate

$ns_ at $duration "finish $ns_ $f $nf {out-mcast.tr} $filename $window"

proc finish {ns_ f nf traceFile fileName window} {
    $ns_ flush-trace
	close $f
	close $nf
    
$ns_ halt
delete $ns_

# Analyze ns trace file with "rateplot" (make gif with gnuplot) 
set rateCmd "rateplot gif window $window auto 3 flow X "
append rateCmd "link 7,8 trace $traceFile $fileName.rate"
puts "mdpvstcp: Running rateplot to create $fileName.rate ..."
puts "mdpvstcp: \"$rateCmd\""
catch {eval exec $rateCmd}
puts "mdpvstcp: Running gnuplot to create $fileName.rate.gif ..."
catch {exec gnuplot -persist $fileName.rate}

# Analyze ns trace file with "lossplot" (make gif with gnuplot) 
set lossCmd "lossplot gif plog mdpLog.txt window $window auto 3 flow X "
append lossCmd "link 7,8 trace $traceFile $fileName.loss"
puts "mdpvstcp: Running lossplot to create $fileName.loss ..."
puts "mdpvstcp: \"$lossCmd\""
catch {eval exec $lossCmd}
puts "mdpvstcp: Running gnuplot to create $fileName.loss.gif ..."
catch {exec gnuplot -persist $fileName.loss}

}

$ns_ run

}

# Run a set of trials
# Eventually use argv,etc to allow input variables from the console
# But, good enough for now...! ;-)

#Usage: ns mdpvstcp.tcl numMdp numTcp bottleneckRate duration window [fast]

set fastStart "off"

if {6 == $argc} {
    if {"fast" == [lindex $argv 5]} {
        puts "mdpvstcp: Using MDP mfastStart ..."
        set fastStart "on"
        set argc 5
    } else {
        puts {mdpvstcp: Error! Invalid command line syntax. (looking for "fast" keyword)}
        Usage
        exit
    }
}
if {5 == $argc} {
    set numM [lindex $argv 0]
    set numT [lindex $argv 1]
    set therate [lindex $argv 2]
    set duration [lindex $argv 3]
    set window [lindex $argv 4]
} elseif {0 == $argc} {
    set numM 1
    set numT 1
    set therate 64kb
    set duration 240.0
    set window 5.0
} else {
    puts "mdpvstcp: Error! Invalid command line syntax."
    Usage
    exit
}

puts "mdpvstcp: Running simulation ... (numMDP:$numM numTCP:$numT bottleneckRate:$therate)"
MDPvsTCP $numM $numT $therate $duration $window $fastStart

