/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
 
#ifndef _MDP_APP
#define _MDP_APP

// This is the base class for an MDPv2-based File Push Application
// Versions for different user interfaces and platforms will be
// derived from this base class - R. Brian Adamson - May 1999

#include "mdpApi.h"
#include "mdpItem.h"
#include "sysdefs.h"

#include <stdio.h>

extern const char* MDPAPP_CMD_LINE_FLAGS;
    
class MdpApp
{
    public:
    // Construction
        MdpApp();
        virtual ~MdpApp();
        bool Init(MdpTimerInstallCallback*  timerInstaller,
                  MdpSocketInstallCallback* sockerInstaller);
        bool Start();
        bool ProcessCommand(char opt, const char* optarg);
        const char* SessionName() {return session_name;}
        virtual void SetPostProcessor(const char* theCmd);
        void SetProcessorOpt(int i, char *opt);
        void OnTxIntervalTimeout();
        static void Usage();      
        
        const char* PostProcessor() {return post_processor;};
        const char* ProcessorOpt(int i) {return processor_opt[i];}  
                
    protected:
    // Methods
        virtual void StartTxIntervalTimer(double delay) = 0;
        virtual void StopTxIntervalTimer() = 0;
        virtual void Alert(const char *format, ...);
        virtual void PostProcess(const char *path);
        virtual void SetStatusText(const char* theText);
        virtual void SetProgressMeter(unsigned int percent);
        void OnExit();
            
    protected:
    // Members
        MdpInstanceHandle mdp_instance;

	private:
        MdpSessionHandle  session_handle;
        FILE*             log_file;
        
        // General parameters
        char            session_name[MDP_SESSION_NAME_MAX];
        char            session_address[MDP_NODE_NAME_MAX];
        unsigned short  session_port;
        unsigned short  session_tx_port;
        unsigned char   session_ttl;
        char            interface_address[32]; // mcast interface
        unsigned char   session_tos;
        bool            session_loopback;
        unsigned long   session_tx_rate;
        int             session_flags;
#ifdef PROTO_DEBUG
        float           tx_packet_drop_rate;
        float           rx_packet_drop_rate;
#endif // PROTO_DEBUG
        bool            status_reporting;
        bool            reuse_ports;
              
        // Client parameters
        char            post_processor[PATH_MAX];
        char*           processor_opt[32];
        MdpFileCache    rx_file_cache;
        bool            archive_mode;
        char            archive_dir[PATH_MAX];
        unsigned long   rx_cache_count_min;
        unsigned long   rx_cache_count_max;
        unsigned long   rx_cache_size_max;
        unsigned long   rx_buffer_size;
        bool            stream_integrity;
        
        // Server parameters
        MdpFileList     tx_file_list;
        bool            tx_cleanup;
        bool            flush_tx_files;
        int             tx_repeat_count;
        double          tx_object_interval;
        double          tx_repeat_interval;
        bool            flow_control;
        float           tx_rate_min;
        float           tx_rate_max;
        float           initial_grtt;
        unsigned short  segment_size;
        unsigned char   ndata;
        unsigned char   nparity;
        unsigned char   auto_parity;
        unsigned long   base_object_id;
        char            ack_list_file[PATH_MAX];
        unsigned long   tx_cache_count_min;
        unsigned long   tx_cache_count_max;
        unsigned long   tx_cache_size_max;
          
    // Methods
        bool OpenLogFile(const char* thePath);
        void CloseLogFile();        
        bool HasPostProcessor() {return (post_processor[0] != '\0');}
        
        static bool MdpNotifyFunc(MdpNotifyCode     notifyCode,
                                  MdpInstanceHandle instanceHandle,
                                  MdpSessionHandle  sessionHandle,
                                  MdpNodeHandle     nodeHandle,
                                  MdpObjectHandle   objectHandle,
                                  MdpError          errorCode);
       
		bool OnNotify(MdpNotifyCode     notifyCode,
                      MdpSessionHandle  sessionHandle,
                      MdpNodeHandle     nodeHandle,
                      MdpObjectHandle   objectHandle,
                      MdpError          errorCode); 
        
};

#endif // MDP_APP
