#include <pwd.h>
#include <iostream>
#include <string>
#include <unistd.h>
#include "cgdbm.h"
#include "sms.h"

using namespace std;

void ShowHelp()
{
	cerr << "Usage:\n\n\tsmsaddr <options>\n";
	cerr << "\tsmsaddr -a ja 602000000\n";
	cerr << "\tsmsaddr -s ja\n\n"; 
	cerr << "-a nick phone : add nickname to address book\n";
	cerr << "-r nick       : remove nickname\n";
	cerr << "-s nick       : search for nickname\n";
	cerr << "-l            : print every item\n"; 
	cerr << "-h            : show this help screen\n";
	cerr << "-V            : show version information\n";
	cerr << "smsaddr " << SMS_VERSION << ", use at your own risk!" << endl;
}

string AddrBookFileName()
{
	string file;
	struct passwd *pwd;
	char *path;

	if ((pwd = getpwuid(geteuid()))) {
		if ((path = getenv("CONFIG_DIR")) && *path)
			file = string(pwd->pw_dir) + "/" + path + "/" + SMS_ADDRBOOK;
		else
			file = string(pwd->pw_dir) + "/." + SMS_ADDRBOOK;
	}
	return file;
}

int main(int argc, char *argv[])
{
	int ch;
	Cgdbm addr;
	
	addr.Open(AddrBookFileName(), 0, GDBM_WRCREAT);
	
	try {
		while ((ch = getopt(argc, argv, "hVa:r:ls:")) != -1) {
			switch (ch) {
			case 'h':
				ShowHelp();
				exit(0);
				break;
			case 'V':
				cout << "sms " << SMS_VERSION << endl;
				exit(0);
				break;
			case 'l':
				// wylistowanie calosci
				try {
					Cdatum key, val;
					key = addr.begin();
					for(;;) {
						val = addr[key];
						cout << string(key) << " => " << string(val) << endl;
						key = addr.next();
					}
					
				}
				catch(...) {
				}
				break;
			case 'a':
				// dodanie rekordu
				if (optind <= argc) {
					Cdatum key(optarg), val(argv[optind]);
					addr.replace(key, val);
					optind++;
				 } else cerr << "Insufficient data" << endl;
				break;
			case 'r':
				{
					// usuniecie rekordu
					Cdatum key(optarg);
					addr.Delete(key);
				}
				break;
			case 's':
				// szukanie rekordow
				try {
					Cdatum key(optarg), val;
					val = addr[key];
					cout << string(key) << " => " << string(val) << endl;
				}
				catch (...) {
				}
				break;
			default:
				ShowHelp();
				exit(0);
			}
		}
	}
	catch (...) {
		cerr << "Exception caught!" << endl;
	}
	
	argc -= optind;
	argv -= optind;
	
	return 0;
}

