#include <stdio.h>
#include "plusmail.h"

using namespace std;

PlusmailSMS::PlusmailSMS(Config &config) : GenericSMS(config)
{
	sendmail_path = config["sendmail_path"];
	email = config["mailaddr"];
}

bool PlusmailSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok = false;
	string cmd, buffer;
	FILE *pf;
	
	cmd = sendmail_path + " -f \"" + email + "\" -t";
	if ((pf = popen(cmd.c_str(), "w"))) {
		buffer = "From: " + email + "\nTo: " + phone_no + "@text.plusgsm.pl\n" +
			"Subject: " + message + "\n\n" + message + "\n.\n";
		ok = fprintf(pf, "%s", buffer.c_str()) == (int)buffer.length();
		pclose(pf);
		
		if (!ok) throw Exception("[1] - popen()");
	}
	
	return ok;
}

