#include <stdlib.h>
#include "mr_pcre/mr_pcre.h"
#include "ideambox.h"

using namespace std;

IdeamboxSMS::IdeamboxSMS(Config &config) : GenericSMS(config)
{
	ideambox_user = config["ideambox_login"];
	ideambox_pass = config["ideambox_pass"];
}

bool IdeamboxSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	Curl_Result result;
	FormParser f_parser;
	string url;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.SetOpt(CURLOPT_COOKIEFILE, "");
	
	while (true) {
		status = curl.PerformGet("http://www.idea.pl/");
		if (status) throw Exception("[1] - get http://www.idea.pl/");
		
		f_parser.SetPage(curl.Body());
		f_parser.ReadForm("loginForm");
		f_parser["login"] = ideambox_user;
		f_parser["password"] = ideambox_pass;
		
		form = f_parser;
		status = curl.PerformPost(f_parser.getAction(), form.PostFields());
		if (status) throw Exception("[2] - post " + f_parser.getAction());
		
		status = curl.PerformGet("http://www.idea.pl/portal/map/map/message_box?mbox_folder=INBOX&mbox_view=messageslist");
		if (status) throw Exception("[3] - post http://www.idea.pl/portal/map/map/message_box?");
		
		status = curl.PerformGet("http://www.idea.pl/portal/map/map/message_box?mbox_view=newsms&mbox_edit=new");
		if (status) throw Exception("[4] - post http://www.idea.pl/portal/map/map/message_box?");
		
		f_parser.SetPage(curl.Body());
		f_parser.ReadForm("sendSMS");
		f_parser["/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.to"] = phone_no.substr(3);
		f_parser["/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.body"] = message;
		f_parser.set("counter", 640 - message.length());
		
		form = f_parser;
		url = "http://www.idea.pl"+f_parser.getAction();
		status = curl.PerformPost(url, form.PostFields());
		if (status) throw Exception("[5] post - " + url);
		
		PcreWrap::Array match;
		if (PcreWrap::pcre_match_all("Twoje SMSy:</td>\\n<td align=\"right\">([0-9]+)", curl.Body(), "mis", match)) {
			ok = strtol(match[0][0].c_str(), NULL, 10) > 0;
		} else throw Exception("[6] - brak potwierdzenia ze strony");
		
		break;
	}
	
	return ok;
}

bool IdeamboxSMS::ShowStats()
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	Curl_Result result;
	FormParser f_parser;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.SetOpt(CURLOPT_COOKIEFILE, "");
	
	while (true) {
		status = curl.PerformGet("http://www.idea.pl/");
		if (status) throw Exception("[1] - get http://www.idea.pl/");
		
		f_parser.SetPage(curl.Body());
		f_parser.ReadForm("loginForm");
		f_parser["login"] = ideambox_user;
		f_parser["password"] = ideambox_pass;
		
		form = f_parser;
		status = curl.PerformPost(f_parser.getAction(), form.PostFields());
		if (status) throw Exception("[2] - post " + f_parser.getAction());
		
		PcreWrap::Array match;
		if (PcreWrap::pcre_match_all("Twoje SMSy:</td>\\n<td align=\"right\">(.*?)", curl.Body(), "mis", match)) {
			cout << "Twoje SMSy: " << match[0][0] << endl;
			ok = true;
		} else throw Exception("[3] - brak potwierdzenia");
		
		break;
	}
	
	return ok;
}

