#include "mr_pcre/mr_pcre.h"
#include "era.h"

using namespace std;

EraSMS::EraSMS(Config &config) : GenericSMS(config)
{
	omnix_user = config["omnix_user"];
	omnix_pass = config["omnix_pass"];
}


bool EraSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok;
	CURLcode status;
	Curl_Form form;
	string headers;
	
	form.AddField("minute", "");
	form.AddField("number", phone_no.substr(1));
	form.AddField("hour", "");
	form.AddField("password", omnix_pass);
	form.AddField("login", omnix_user);
	form.AddField("message", message);
	form.AddField("success", "http://localhost/era");
	form.AddField("contact", "");
	form.AddField("failure", "http://localhost/era");
	
	status = curl.PerformPost("http://www.eraomnix.pl/sms/do/extern/tinker/free/send", form.PostFields());
	if (status == 0) {
	  PcreWrap::Array match;
	  if (PcreWrap::pcre_match_all("X-ERA-([a-z]+)=([0-9]+)", curl.Headers(), "mis", match)) {
	    if (match[0][0] == "counter") {
	      ok = false;
	      cout << "Wiadomo wysana. Do koca dnia moesz wysa ";
	      if (strtol(match[0][1].c_str(), NULL, 10) == 1)
		cout << "tylko jedn wiadomo." << endl;
	      else
		cout << "jeszcze " << match[0][1] << " wiadomoci." << endl;
	    } else if (match[0][0] == "error") {
	      ok = true;
	      switch (strtol(match[0][1].c_str(), NULL, 10)) {
	      case 0: cerr << "Wysyka bez bdu" << endl; 
		break;
	      case 1: cerr << "Bd (1): awaria systemu" << endl; 
		break;
	      case 2: cerr << "Bd (2): uytkownik nieautoryzowany" << endl; 
		break;
	      case 3: cerr << "Bd (3): dostp zablokowany" << endl; 
		break;
	      case 5: cerr << "Bd (5): bd skadni" << endl; 
		break;
	      case 7: cerr << "Bd (7): wyczerpany limit wiadomoci" << endl; 
		break;
	      case 8: cerr << "Bd (8): bdny numer odbiorcy wiadomoci" 
			   << endl; 
		break;
	      case 9: cerr << "Bd (9): wiadomo zbyt duga" << endl; 
		break;
	      case 10: cerr << "Bd (10): brak wymaganej liczby etonw" 
			    << endl;
		break;
	      default: cerr << "Bd (?): nieznany kod bdu" << endl;
	      }
	    }
	  } else throw Exception("[1] - brak potwierdzenia ze strony");
	} else throw Exception("[2] post - unknown error");
	
	return ok;
}

