/*
** Copyright (c) 1986, 1994, 1996, 2000, 2002
**	Jeff Forys (jeffware@marjum.com).  All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that: (1) Redistributions of
** source code must retain the above copyright notice, this list of
** conditions and the following disclaimer, (2) Redistributions in
** binary form must reproduce the above copyright notice, this list
** of conditions and the following disclaimer in the documentation
** and/or other materials provided with the distribution, (3) All
** advertising materials mentioning features or use of this software
** must display the following acknowledgment: ``This product includes
** software developed by Jeff Forys (jeffware@marjum.com).'', (4)
** The name of the author may not be used to endorse or promote products
** derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef lint
static char rcsid[] = "$Id: irix-5.c,v 1.7 2005/04/06 23:49:35 forys Exp $";
#endif

#define	NO_MEXTERN
#include "conf.h"
#undef	NO_MEXTERN

#include <sys/resource.h>

#include <stdio.h>
#include <dirent.h>

extern int MissedProcCnt;

/*
 * Define SigNames, NSig, and TtyDevDir here; they are used by other
 * routines and must be global.  Everyone seems to have their own
 * idea as to what NSIG should be.  Here, `NSig' is the number of
 * signals available, not counting zero.
 */
char *SigMap[] = { "0",
	"HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT",		/*  1 -  6 */
	"EMT", "FPE", "KILL", "BUS", "SEGV", "SYS",		/*  7 - 12 */
	"PIPE", "ALRM", "TERM", "USR1", "USR2", "CHLD",		/* 13 - 18 */
	"PWR", "WINCH", "URG", "POLL", "STOP", "TSTP",		/* 19 - 24 */
	"CONT", "TTIN", "TTOU", "VTALRM", "PROF", "XCPU",	/* 25 - 30 */
	"XFSZ", "32", "33", "34", "35", "36",			/* 31 - 36 */
        "37", "38", "39", "40", "41", "42",			/* 37 - 42 */
        "43", "44", "45", "46", "47", "48",			/* 43 - 48 */
        "SIGRTMIN", "50", "51", "52", "53", "54",		/* 49 - 54 */
        "55", "56", "57", "58", "59", "60",			/* 55 - 60 */
        "61", "62", "63", "SIGRTMAX",				/* 61 - 64 */
};
int NSig = NUMSIGS;

#define	SETCMD(dst,src,maxlen) {			\
	extern char *strrchr();				\
	if (maxlen > 0) src[maxlen] = '\0';		\
	dst = (dst = strrchr(src, '/')) ? ++dst: src;	\
}

static char *TtyDevDir = "/dev";

int	Skill;			/* set 1 if running `skill', 0 if `snice' */
int	PrioMin, PrioMax;	/* min and max process priorities */
int	SigPri;			/* signal to send or priority to set */
pid_T	MyPid;			/* pid of this process */
uid_T	MyUid;			/* uid of this process */
char	*ProgName;		/* program name */

/*
 * This is the machine-dependent initialization routine.
 *
 *   - The following global variables must be initialized:
 *     MyPid, MyUid, ProgName, Skill, PrioMin, PrioMax, SigPri
 *   - The working directory will be changed to that which contains the
 *     tty devices (`TtyDevDir'); this makes argument parsing go faster.
 *   - If possible, this routine should raise the priority of this process.
 */
void
MdepInit(pname)
	char *pname;
{
	extern char *rindex(), *SysErr();

	MyPid = (pid_T) getpid();
	MyUid = (uid_T) getuid();
	SETCMD(ProgName, pname, 0)

	/*
	 * If we are running as root, raise our priority to better
	 * catch runaway processes.
	 */
	if (MyUid == ROOTUID)
		(void) setpriority(PRIO_PROCESS, MyPid, PRIO_MIN);

	/*
	 * Determine what we are doing to processes we find.  We will
	 * either send them a signal (skill), or renice them (snice).
	 */
	Skill = (strstr(ProgName, "snice") == NULL);

	/*
	 * chdir to `TtyDevDir' to speed up tty argument parsing.
	 */
	if (chdir(TtyDevDir) < 0) {
		fprintf(stderr, "%s: chdir(%s): %s\n", ProgName, TtyDevDir,
		        SysErr());
		exit(EX_SERR);
	}

	/*
	 * Set up minimum and maximum process priorities.
	 * Initialize SigPri to either default signal (`skill') or
	 * default priority (`snice').
	 */
	PrioMin = PRIO_MIN;
	PrioMax = PRIO_MAX;
	SigPri = Skill? SIGTERM: 4;
}

/*
 * Carry out an action on a particular process.  If this is `skill',
 * then send the process a signal, otherwise this is `snice' so change
 * it's priority.
 *
 * If 0 is returned, the operation was successful, otherwise -1 is
 * returned and `errno' set.
 */
int
MdepAction(pid)
	pid_T pid;
{
	if (Skill)
		return(kill((int)pid, SigPri));
	else
		return(setpriority(PRIO_PROCESS, (int)pid, SigPri));
}

/* disable regular expresions: regex(3) availability unknown */
NULL_REGEX_FUNCS

/*
 * Now, set up everything we need to write a GetProc() routine.
 */

#include <sys/procfs.h>
#include <fcntl.h>

static char *ProcDir =	"/proc/pinfo";		/* proc directory */
static char *ProcFil =	"/proc/pinfo/%s";	/* proc image status's */

/*
 * GetProc()
 *
 * Fill in and return a `struct ProcInfo' with information about the
 * next process.  If no processes are left, return NULL.
 */
struct ProcInfo *
GetProc()
{
	extern char *SysErr();
	static char *zombie = "<defunct>";
	static struct ProcInfo procinfo;
	static DIR *dirfp = NULL;
	static struct prpsinfo pinfo;
	struct dirent *dp;
	char flnm[FILENAME_MAX];
	int fd;

	/*
	 * If this is our first time here, open the proc directory,...
	 */
	if (dirfp == NULL && (dirfp=opendir(ProcDir)) == NULL) {
		fprintf(stderr, "%s: %s: %s\n", ProgName, ProcDir, SysErr());
		exit(EX_SERR);
	}

	while ((dp = readdir(dirfp)) != NULL) {
		if (strcmp(dp->d_name,".") == 0 || strcmp(dp->d_name,"..") == 0)
			continue;
		(void) sprintf(flnm, ProcFil, dp->d_name);
		if ((fd = open(flnm, O_RDONLY)) < 0) {
			MissedProcCnt++;
			continue;	/* ignore procs we don't own */
		}
		if (ioctl(fd, PIOCPSINFO, &pinfo) == -1) {
			(void) close(fd);
			continue;	/* ignore these too */
		}
		(void) close(fd);

		/*
		 * Information about a process now resides in 'pinfo'.
		 */
		procinfo.pi_flags = 0;
		procinfo.pi_pid = pinfo.pr_pid;
		procinfo.pi_uid = pinfo.pr_uid;
		if (pinfo.pr_zomb != 0) {
			procinfo.pi_flags |= PI_ZOMBIE;
			procinfo.pi_cmd = zombie;
		} else {
			if (pinfo.pr_pid < 6)	/* low pids are special */
				procinfo.pi_flags |= PI_ASKUSR;
			if (pinfo.pr_ttydev != PRNODEV) {
				procinfo.pi_flags |= PI_CTLTTY;
				procinfo.pi_tty = pinfo.pr_ttydev;
			}
			procinfo.pi_cmd = pinfo.pr_fname;
		}
		return(&procinfo);
	}

	(void) closedir(dirfp);
	dirfp = NULL;
	return((struct ProcInfo *)NULL);
}
