/* *******************************************************************
** Copyright (c) 1993-2012 Seiji Kaneko. All rights reserved.
** Everyone is permitted to use this program in source and binary
** form, with or without modification if and only if the following
** conditions are met:
** 1. Redistributions of source code must retain the above copyright
**   notice, copyright notice written in source code, additional list
**   of conditions and the following disclaimer.
** 2. Redistributions in machine readable form must reproduce the 
**   above copyright notice and the following disclaimer in the
**   documentation or other material provided with the distribution.
** 3. Neither the name of the copyright holders nor the names of its 
**   contributors may be used to endorse or promote products derived from 
**   this software without specific prior written permission.
**********************************************************************
** Disclaimer: This software is provided and distributed AS IS, 
**	without any implicit or explicit warranties, and not
**	guaranteed to be error-free. In no event shall the author be
**	liable for any direct, indirect or incidental damages,
**	including, but not limited to, loss of data, use or profits
**	responsibility for any direct or indirect damages or results
**	arising by using whole or a part of this software.
**********************************************************************
	skf_fileio.h:	file io routine header
		v1.30	for skf v1.30
	$Id: skf_fileio.c,v 1.45 2012/01/04 14:26:56 seiji Exp seiji $
*/

#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#include <sys/stat.h>
#include <sys/types.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <errno.h>

#if defined(__MINGW32__)
#include <windows.h>
#define		skf_sleep	Sleep
#else
#include <sys/stat.h>
#define		skf_sleep	sleep
#endif

#include "skf.h"
#include "skf_fileio.h"
#include "oconv.h"

int    hold_size = 0;

static	short   hold_count = 0;
static	short   hold_pntr = 0;

static  int	hold_buf[DEFAULT_HOLD_SIZE];

/* --------------------------------------------------------------- */
/* hold stack control: This is treated as Queue			   */
/* Memo: Since program pushes at most 2-byte without test, at	   */
/*	 least 2 space to push is reserved to stack full test.	   */
/* --------------------------------------------------------------- */

/* queue control						   */
void enque(c)
int c;
{
	if (hold_count == DEFAULT_HOLD_SIZE) hold_count = 0;
	hold_buf[hold_count++] = c; hold_size++;
}

int deque()
{
	int s ;

	if (!Qempty) {
		s = hold_buf[hold_pntr++]; hold_size--;
		if (hold_pntr == DEFAULT_HOLD_SIZE) hold_pntr = 0;
	} else s = sEOF;
	return(s);
}

void Qflush()
{
	hold_pntr = 0; hold_count = 0; hold_size = 0;
}

#if defined(SWIG_EXT)
/* --------------------------------------------------------------- */
/* buffers							   */
/* --------------------------------------------------------------- */
unsigned char *stdibuf;

/* --------------------------------------------------------------- */
/* SWIG								   */
/* --------------------------------------------------------------- */
long	buf_p = 0;
long	skf_fpntr;
long	obuf_p = 0;

void *skf_fopen(len,str)
char	*len;
char	*str;
{
    return ((void *)0);
}

int	skf_fillbuf(p)
int	*p;		/* file descripter			  */
{
	skf_fpntr = 0;
	return(sEOF);
}

#else	
/* --------------------------------------------------------------- */
/* not SWIG							   */
/* --------------------------------------------------------------- */
/* buffers							   */
/* --------------------------------------------------------------- */
unsigned char stdobuf[O_BUFSIZ];
unsigned char *stdibuf;

#if defined(FAST_GETC)

skfFILE skf_infile;

long	buf_p = 0;
long	obuf_p = 0;
long	skf_fpntr;

/*@null@*/ /*@-paramuse@*/ /*ARGSUSED*/ /*@-immediatetrans@*/
skfFILE *skf_fopen(name,mode)
char	*name;
char	*mode;
{
	/* actually, skf_fopen is called only with mode "r", we	  */
	/* don't have to make certain.				  */
	skf_infile = (skfFILE) open(name, O_RDONLY);
	buf_p = -1; skf_fpntr = 0; 
	Qflush();
	if (skf_infile >=0) return ((skfFILE *) &skf_infile);
		else	    return (NULL);
}

int	skf_fillbuf(p)
int	*p;		/* file descripter			  */
{
	/* This routine only loops when no character is avaliable.*/
	/* Maybe I should pause for signals, but this one is for  */
	/* portability by sacrificing performance.		  */

	buf_p = (int) read(*p,stdibuf,(size_t)I_BUFSIZ);
	while (buf_p < 0) {
	    skf_readerr(errno);
	    if (errno != EAGAIN) {
		return(sABRT);
	    } else {
		skf_sleep(1);	/* do not exhaust CPU time	  */
	    };
	};
	skf_fpntr = 0;
	return ((buf_p == 0) ? sEOF : (stdibuf[skf_fpntr++]));
}

/* output file descriptor initialization. */
void skf_ioinit(fout)
skfFILE *fout;	/* stdout */
{
    if ((stdibuf = calloc((size_t)I_BUFSIZ,sizeof(unsigned char)))
	    == NULL) {
	skferr(SKF_MALLOCERR,(long)1,(long)0);
	skf_exit(EXIT_FAILURE);
    };
    setvbuffer((FILE *)fout, (char *)stdobuf, O_BUFSIZ);

/* --- preconversion output prepare ------------------------------ */
    if (o_add_bom) show_endian_out();
    if (add_annon) print_announce(out_codeset);

    show_lang_tag();
    return;
}

/* output flush buffer			*/
void SKFfflush(f)
skfFILE	*f;
{
#ifdef USE_FWRITE
    if ((fwrite(stdobuf,sizeof(unsigned char),obuf_p,stdout)) < obuf_p) {
	skferr(SKF_PUTFAILERR,(long)1,(long)0);
	skf_exit(EXIT_FAILURE);
    };
#else
    oconv(sFLSH);
    fflush((FILE *)f);
#endif
    obuf_p = 0;
}

/* output file_output			*/
int skf_oflush(ch)
int ch;
{
    SKFfflush((skfFILE *)stdout);
    obuf_p = 1;
    stdobuf[0] = (unsigned char) ch;
    return(0);
}

#else	/* !FAST_GETC */
/*@-dependenttrans@*/ /*@-nullret@*/
FILE *skf_fopen(name,mode)
char *name;
char *mode;
{
	FILE *ifi;

	if ((stdibuf = calloc((size_t)I_BUFSIZ,sizeof(unsigned char)))
		== NULL) {
	    skferr(SKF_MALLOCERR,(long)1,(long)0);
	    skf_exit(EXIT_FAILURE);
	};
	ifi = fopen(name,mode);
	return(ifi);
}

int rGETC(f)
skfFILE *f;
{
    int ch;
    if ((ch = getc(f)) == EOF) return(sEOF);
    else return(ch);
}

/* output file descriptor initialization. */
void skf_ioinit(fout)
skfFILE *fout;	/* stdout */
{
    setvbuffer(fout, stdobuf, O_BUFSIZ);
/* --- preconversion output prepare ------------------------------ */
    if (o_add_bom) show_endian_out();
    if (add_annon) print_announce(out_codeset);

    show_lang_tag();
    return;
}

#endif	/* !SWIG && !FAST_GETC */
#endif

/* --------------------------------------------------------------- */
/* we need function to calculate string length			   */
/* --------------------------------------------------------------- */
size_t  skf_strlen(str,maxlen)
char *str;
int maxlen;
{
    int i;
    size_t len;

    for (i=0,len=0;((i<maxlen) && (*str!='\0')); i++,str++,len++);

    return(len);
}

/* --------------------------------------------------------------- */
/* mkstemp wrapper						   */
/* --------------------------------------------------------------- */
int	skf_mkstemp(nam)
char	*nam;
{
#ifdef HAVE_MKSTEMP
    return(mkstemp(nam));
#else
	/* FIXME */
    return(mkstemp(nam));
#endif
}

/* --------------------------------------------------------------- */
