#!/usr/bin/env perl
use strict;

##
## This is a script that generates tame_tfork_ag.h -- the autogenerated
## parts of tame_tfork.h
##

my $N_wv = 3;
my $name = "_tfork";

sub mklist ($$)
{
    my ($tmplt, $n) = @_;
    my @out;
    for (my $i = 1; $i <= $n; $i++) {
	my $a = $tmplt;
	$a =~ s/%/$i/g;
	push @out, $a;
    }
    return @out
}

sub mklist_multi (@)
{
    my @arr;
    foreach my $e (@_) {
	if (ref ($e)) {
	    push @arr, mklist ($e->[0], $e->[1]);
	} else {
	    push @arr, $e;
	}
    }
    return @arr;
}

sub commafy {
    return join (", " , @_);
}

sub arglist (@)
{
    return commafy (mklist_multi (@_));
}

sub do_tfork ($$) {
    my ($r, $w) = @_;
    print ("template<" . arglist(["class R%", $r], ["class W%", $w]) . "> ",
	   "void\n",
	   "${name} (",
	   arglist ("ptr<closure_t> c",
		    "const char *loc",
		    "rendezvous_t<" . arglist (["W%", $w]) . "> &rv",
		    ["const W% &w%", $w],
		    ["R% &r%", $r],
		    "typename callback<" . 
		    arglist (["R%", $r], "void"). ">::ref a"
		    ),
	   ")\n",
	   "{\n",
	   "  __tfork (" . arglist ("loc",
				    "_mkevent (" . arglist ( "c",
							     "loc",
							     "rv",
							     ["w%", $w]
							     ) . ")",
				    ["r%", $r],
				    "a") . ");\n",
	   "}\n\n");

}

print <<EOF;
// -*-c++-*-
//
// Autogenerated by mktfork_ag.pl
//

#ifndef _LIBTAME_TAME_TFORK_AG_H_
#define _LIBTAME_TAME_TFORK_AG_H_ 1

EOF


for (my $w = 0; $w <= $N_wv; $w++) {
    for (my $r = 0; $r <= 1; $r++) {
	if ($w > 0 || $r > 0) {
	    do_tfork ($r, $w);
	}
    }
}


print <<EOF;
#endif //_LIBTAME_TAME_TFORK_AG_H_ 1
EOF
