/* $Id: tcpconnect.C,v 1.5 2002/10/14 03:53:03 kolya Exp $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "async.h"
#include "dns.h"

struct tcpconn_s {
  bool cancel;
  bool called;
  cbi cb;

  tcpconn_s (cbi c) : cancel (false), called (false), cb (c) {}
  void call (int fd) { called = true; if (!cancel) (*cb) (fd); }
};

static void
tcpconnect_addr_cb (int fd, tcpconn_t tc)
{
  fdcb (fd, selwrite, NULL);

  sockaddr_in sin;
  socklen_t sn = sizeof (sin);
  if (!getpeername (fd, (sockaddr *) &sin, &sn)) {
    tc->call (fd);
    return;
  }

  int err = 0;
  sn = sizeof (err);
  getsockopt (fd, SOL_SOCKET, SO_ERROR, (char *) &err, &sn);
  close (fd);
  errno = err ? err : ECONNREFUSED;
  tc->call (-1);
}

static void
tcpconnect (in_addr addr, u_int16_t port, tcpconn_t tc)
{
  sockaddr_in sin;
  bzero (&sin, sizeof (sin));
  sin.sin_family = AF_INET;
  sin.sin_port = htons (port);
  sin.sin_addr = addr;

  int fd = inetsocket (SOCK_STREAM);
  if (fd < 0) {
    tc->call (-1);
    return;
  }
  make_async (fd);
  close_on_exec (fd);
  if (connect (fd, (sockaddr *) &sin, sizeof (sin)) < 0
      && errno != EINPROGRESS) {
    close (fd);
    tc->call (-1);
    return;
  }
  fdcb (fd, selwrite, wrap (tcpconnect_addr_cb, fd, tc));
}

tcpconn_t
tcpconnect (in_addr addr, u_int16_t port, cbi cb)
{
  tcpconn_t tc = New refcounted<tcpconn_s> (cb);
  tcpconnect (addr, port, tc);
  return tc->called ? (tcpconn_t) NULL : tc;
}

static void
tcpconnect_name_cb (u_int16_t port, str *namep,
		    tcpconn_t tc, ptr<hostent> h, int err)
{
  if (!h) {
    errno = ENOENT;
    tc->call (-1);
    return;
  }
  if (namep)
    *namep = h->h_name;
  tcpconnect (*(in_addr *) h->h_addr, port, tc);
}

tcpconn_t
tcpconnect (str hostname, u_int16_t port, cbi cb, bool dnssearch,
	    str *namep)
{
  tcpconn_t tc = New refcounted<tcpconn_s> (cb);
  dns_hostbyname (hostname, wrap (tcpconnect_name_cb, port, namep, tc),
		  dnssearch);
  return tc->called ? (tcpconn_t) NULL : tc;
}

void
tcpconnect_cancel (tcpconn_t tc)
{
  tc->cancel = true;
}
