/* $Id: suidprotect.c,v 1.4 2002/08/22 23:00:44 dm Exp $ */

/*
 *
 * Copyright (C) 2001 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "sysconf.h"

int
suidsafe (void)
{
  static int safe;
  if (!safe) {
    if (suidprotect && getuid ()
#if defined (HAVE_ISSETUGID)
	     && issetugid ()
#elif defined (HAVE_GETEUID) && defined (HAVE_GETEGID)
	     && (getuid () != geteuid () || getgid () != getegid ())
#endif /* HAVE_GETEUID and HAVE_GETEGID */
	     )
      safe = -1;
    else
      safe = 1;
  }
  return safe < 0 ? 0 : 1;
}

int
execsafe (void)
{
  return (suidprotect || execprotect) ? 0 : 1;
}

char *
safegetenv (const char *name)
{
  return suidsafe () ? getenv (name) : NULL;
}

#ifndef PUTENV_COPIES_ARGUMENT
int
xputenv (const char *s)
{
  /* Note:  Don't use xstrdup, because we don't always link this file
   * against libasync.  (suidconnect uses it, too) */
  char *ss = strdup (s);
  int ret;
  if (!ss) {
    char msg[] = "xputenv: out of memory\n";
    write (2, msg, sizeof (msg) - 1);
    abort ();
  }
  ret = putenv (ss);
  if (ret < 0)
    xfree (ss);
  return ret;
}
#endif /* !PUTENV_COPIES_ARGUMENT */
