/* $Id: sfskeyhostid.C,v 1.9 2002/12/03 03:54:41 kaminsky Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "sfskey.h"

void
hostidprint (str host, str service, bool secure, ptr<sfscon> sc, str err)
{
  if (!sc) {
    if (host == "-")
      host = "localhost";
    warn ("Could not contact service `%s' on host `%s'\n", 
	  service.cstr (), host.cstr ());
    exit (1);
  }
  if (!secure)
    warnx << "WARNING: RETRIEVING HOSTID INSECURELY OVER THE NETWORK\n";
  err_flush ();
  strbuf msg;
  msg << sc->path << "\n";
  make_sync (1);
  msg.tosuio ()->output (1);
  exit (0);
}

sfs_service
getservice (const char *optarg)
{
  if (!strcasecmp (optarg, "sfs"))
    return SFS_SFS;
  else if (!strcasecmp (optarg, "authserv"))
    return SFS_AUTHSERV;
  else if (!strcasecmp (optarg, "rex"))
    return SFS_REX;
  else
    fatal << "service must be one of\n"
	  << "   sfs\n"
	  << "   authserv\n"
	  << "   rex\n";
}

void
sfskey_hostid (int argc, char **argv)
{
  int ch;
  str opt_service ("sfs");
  str host;

  while ((ch = getopt (argc, argv, "s:")) != -1)
    switch (ch) {
    case 's':
      opt_service = optarg;
      break;
    default:
      usage ();
      break;
    }
  if (optind + 1 != argc)
    usage ();
  host = argv[optind];

  if (host == "-" && strcasecmp (opt_service, "authserv")) {
    warn << "Host `-' (localhost) implies service `authserv'..."
         << "Overriding your choice of `" << opt_service << "'.\n";
    opt_service = "authserv";
  }

  sfs_connect_host (host, getservice (opt_service),
		    wrap (hostidprint, host, opt_service,
		          host == "-" || opt_quiet),
		    false);
}
