/*
 * tnmWinLog.c --
 *
 *	Windows specific functions to write to the system logging facility.
 *
 * Copyright (c) 1996      University of Twente.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tnmInt.h"
#include "tnmPort.h"

#include <windows.h>


/*
 *----------------------------------------------------------------------
 *
 * TnmWriteLogMessage --
 *
 *	This procedure is invoked to write a message to the Windows 
 *	system logging facility. The UNIX specific logging type is
 *	converted to one of the three Windows event types.
 *
 * 	Note, Windows NT has a far more sophisticated event logging
 *	system than UNIX. But we can't make use of all the good stuff
 *	because we would need system administrator priviledges for
 *	this. See the Byte article "Windows NT Event Logging" (April
 *	1996) for an example how to hack these things.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	A message is written to the system logging facility.
 *
 *----------------------------------------------------------------------
 */

int
TnmWriteLogMessage(interp, level, message)
    Tcl_Interp *interp;
    int level;
    char *message;
{
    HANDLE ed;
    char *msgList[1];
    WORD type;
    WORD category = 0;
    DWORD id = getpid();

    switch (level) {
      case TNM_LOG_EMERG:
      case TNM_LOG_ALERT:
      case TNM_LOG_CRIT:
      case TNM_LOG_ERR:
	type = EVENTLOG_ERROR_TYPE;
	break;
      case TNM_LOG_WARNING:
      case TNM_LOG_NOTICE:
	type = EVENTLOG_WARNING_TYPE;
	break;
      case TNM_LOG_INFO:
      case TNM_LOG_DEBUG:
	type = EVENTLOG_INFORMATION_TYPE;
	break;
      default:
	if (interp) {
	    Tcl_SetResult(interp, "illegal system logging level", TCL_STATIC);
	}
	return TCL_ERROR;
    }

    ed = RegisterEventSource(NULL, "scotty");
    if (ed != NULL) {
	msgList[0] = message;
	ReportEvent(ed, type, category, id, NULL, 1, 0, msgList, NULL);
	DeregisterEventSource(ed);
    }

    return TCL_OK;
}
