/****************************************************/
/* Bibliotheque qui charge des objets 3d a partir   */
/* de fichiers OBJ                                  */
/* obj_3d_from_obj.c                                */
/*                                                  */
/* Ecrit par : Daniel Lacroix (all rights reserved) */
/*                                                  */
/****************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <obj_3d_from_obj.h>

#define DIFFUSE  0.4
#define SPECULAR 0.6
#define SHINE    20.0

static uint32 obj_3d_new_from_obj_first_pass(obj_3d *pobj_3d, FILE* file)
{
  uint32    numvertices;		/* number of vertices in model */
  uint32    numnormals;			/* number of normals in model */
  uint32    numtriangles;		/* number of triangles in model */
  unsigned  v, n, t;
  char      buf[128];

  numvertices = numnormals = numtriangles = 0;
  while(fscanf(file, "%s", buf) != EOF) {
    switch(buf[0]) {
    case '#':				/* comment */
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      break;
    case 'v':				/* v, vn, vt */
      switch(buf[1]) {
      case '\0':			/* vertex */
	/* eat up rest of line */
	fgets(buf, sizeof(buf), file);
	numvertices++;
	break;
      case 'n':				/* normal */
	/* eat up rest of line */
	fgets(buf, sizeof(buf), file);
	numnormals++;
	break;
      case 't':				/* texcoord */
	/* eat up rest of line */
	fgets(buf, sizeof(buf), file);
	break;
      default:
	printf("obj_3d_new_from_obj_first_pass(): Unknown token \"%s\".\n", buf);
	exit(1);
	break;
      }
      break;
    case 'm':
      fgets(buf, sizeof(buf), file);
      sscanf(buf, "%s %s", buf, buf);
      break;
    case 'u':
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      break;
    case 'g':				/* group */
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      sscanf(buf, "%s", buf);
      break;
    case 'f':				/* face */
      v = n = t = 0;
      fscanf(file, "%s", buf);
      /* can be one of %d, %d//%d, %d/%d, %d/%d/%d %d//%d */
      if (strstr(buf, "//")) {
	/* v//n */
	sscanf(buf, "%d//%d", &v, &n);
	fscanf(file, "%d//%d", &v, &n);
	fscanf(file, "%d//%d", &v, &n);
	numtriangles++;
	while(fscanf(file, "%d//%d", &v, &n) > 0) {
	  numtriangles++;
	}
      } else if (sscanf(buf, "%d/%d/%d", &v, &t, &n) == 3) {
	/* v/t/n */
	fscanf(file, "%d/%d/%d", &v, &t, &n);
	fscanf(file, "%d/%d/%d", &v, &t, &n);
	numtriangles++;
	while(fscanf(file, "%d/%d/%d", &v, &t, &n) > 0) {
	  numtriangles++;
	}
      } else if (sscanf(buf, "%d/%d", &v, &t) == 2) {
	/* v/t */
	fscanf(file, "%d/%d", &v, &t);
	fscanf(file, "%d/%d", &v, &t);
	numtriangles++;
	while(fscanf(file, "%d/%d", &v, &t) > 0) {
	  numtriangles++;
	}
      } else {
	/* v */
	fscanf(file, "%d", &v);
	fscanf(file, "%d", &v);
	numtriangles++;
	while(fscanf(file, "%d", &v) > 0) {
	  numtriangles++;
	}
      }
      break;

    default:
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      break;
    }
  }

  pobj_3d->nb_face = numtriangles;
  pobj_3d->nb_dot  = numvertices;
  return(numnormals);
}

/*************************************************/
/* Renvoi l'objet 3d contenu dans le fichier OBJ */
/* ou NULL si impossible                         */
obj_3d *obj_3d_new_from_obj(char *filename)
{ 
  obj_3d *vobj_3d;

  FILE *fichier;
  char tmp_str[120];
  char tmp_char;
  int  vertices, faces, count, vNum, tempA, tempB, tempC;
  uint32 nb_normal;
  dot_3d *tmp_normal;
  uint32 *tmp_face_normal;

  /* alloue la memoire pour la structure de base de l'objet 3D */
  if((vobj_3d = (obj_3d *)malloc(sizeof(obj_3d))) == NULL)
  { perror("malloc failed "); exit(1); }

  /* mode de rendu */
/*  vobj_3d->render_type = FLAT;*/
  vobj_3d->fill_mode = FLAT;
  /* numero d'identifiant de l'objet (utilise dans obj_buf) */
  vobj_3d->id      = 0;
  /* nombre de polygone de cet objet */
  vobj_3d->nb_face = 0;
  /* definition de tout les polygones */
  vobj_3d->face    = NULL;
  /* nombre de point de cet objet */
  vobj_3d->nb_dot  = 0;
  /* definition de tout les points (utilise dans les polygones) */
  vobj_3d->dot     = NULL;
  /* tampon pour les calculs des points de l'objet apres transformation */
  vobj_3d->dot_tmp = NULL;
  /* vecteur normaux (utilise dans les polygones) */
  vobj_3d->normal  = NULL;
  /* vecteur normaux en chaque sommet */
  vobj_3d->normal_dot = NULL;
  /* transformation a appliquer sur l'objet (null si aucune) */
  vobj_3d->obj_mat = NULL;

  /* ouverture du fichier ASC */
  if((fichier = fopen(filename, "r")) == NULL)
  { free(vobj_3d); return(NULL); }

  nb_normal = obj_3d_new_from_obj_first_pass(vobj_3d, fichier);

  /* alloue la mmoire pour les points */
  if(vobj_3d->nb_dot)
    if((vobj_3d->dot = (dot_3d *)malloc(vobj_3d->nb_dot*sizeof(dot_3d))) == NULL)
    { perror("malloc failed "); exit(1); }

  /* alloue la mmoire pour les faces */
  if(vobj_3d->nb_face)
    if((vobj_3d->face = (face *)malloc(vobj_3d->nb_face*sizeof(face))) == NULL)
    { perror("malloc failed "); exit(1); }

  if(nb_normal)
  {
    if((tmp_normal = (dot_3d *)malloc(nb_normal*sizeof(dot_3d))) == NULL)
    { perror("malloc failed "); exit(1); }

    if((tmp_face_normal = (uint32 *)malloc(vobj_3d->nb_face*3*sizeof(uint32)*3)) == NULL)
    { perror("malloc failed "); exit(1); }
  }

/***************************/
{
  uint32    numvertices;		/* number of vertices in model */
  uint32    numnormals;			/* number of normals in model */
  uint32    numtriangles;		/* number of triangles in model */
  char      buf[128];
  float     bidon;
  uint32    v, n, t;
  FILE      *file = fichier;

  /* rewind to beginning of file and read in the data this pass */
  rewind(file);

  /* on the second pass through the file, read all the data into the
     allocated arrays */
  numvertices = numnormals = 0;
  numtriangles = 0;
  while(fscanf(file, "%s", buf) != EOF) {
    switch(buf[0]) {
    case '#':				/* comment */
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      break;
    case 'v':				/* v, vn, vt */
      switch(buf[1]) {
      case '\0':			/* vertex */
	fscanf(file, "%f %f %f", 
	       &(vobj_3d->dot[numvertices].x), 
	       &(vobj_3d->dot[numvertices].y), 
	       &(vobj_3d->dot[numvertices].z));
/*        printf("vertex (%.2f,%.2f,%.2f)\n",
          vobj_3d->dot[numvertices].x,
          vobj_3d->dot[numvertices].y,
          vobj_3d->dot[numvertices].z);*/
	numvertices++;
	break;
      case 'n':				/* normal */
	fscanf(file, "%f %f %f", 
	       &(tmp_normal[numnormals].x),
	       &(tmp_normal[numnormals].y), 
	       &(tmp_normal[numnormals].z));
        normalize(&tmp_normal[numnormals]);
	numnormals++;
	break;
      case 't':				/* texcoord */
	fscanf(file, "%f %f", 
	       &bidon,
	       &bidon);
	/*numtexcoords++;*/
	break;
      }
      break;
    case 'u':
      fgets(buf, sizeof(buf), file);
      sscanf(buf, "%s %s", buf, buf);
      break;
    case 'g':				/* group */
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      sscanf(buf, "%s", buf);
      break;
    case 'f':				/* face */
      v = n = t = 0;
      fscanf(file, "%s", buf);
      /* can be one of %d, %d//%d, %d/%d, %d/%d/%d %d//%d */
      if (strstr(buf, "//")) {
	/* v//n */
	sscanf(buf, "%d//%d", &v, &n);
	vobj_3d->face[numtriangles].pt1 = v-1;
	tmp_face_normal[numtriangles*3] = n-1;
	fscanf(file, "%d//%d", &v, &n);
	vobj_3d->face[numtriangles].pt2 = v-1;
	tmp_face_normal[numtriangles*3+1] = n-1;
	fscanf(file, "%d//%d", &v, &n);
	vobj_3d->face[numtriangles].pt3 = v-1;
	tmp_face_normal[numtriangles*3+2] = n-1;
        /* fixe des proprites arbitraires */
        /* de rflexion de la lumire      */
        vobj_3d->face[numtriangles].diffuse = DIFFUSE;
        vobj_3d->face[numtriangles].speculaire = SPECULAR;
        vobj_3d->face[numtriangles].shine = SHINE;
	numtriangles++;
	while(fscanf(file, "%d//%d", &v, &n) > 0) {
	  vobj_3d->face[numtriangles].pt1 = vobj_3d->face[numtriangles-1].pt1;
          tmp_face_normal[numtriangles*3] = tmp_face_normal[(numtriangles-1)*3];
	  vobj_3d->face[numtriangles].pt2 = vobj_3d->face[numtriangles-1].pt3;
          tmp_face_normal[numtriangles*3+1] = tmp_face_normal[(numtriangles-1)*3+2];
	  vobj_3d->face[numtriangles].pt3 = v-1;
          tmp_face_normal[numtriangles*3+2] = n-1;
          /* fixe des proprites arbitraires */
          /* de rflexion de la lumire      */
          vobj_3d->face[numtriangles].diffuse = DIFFUSE;
          vobj_3d->face[numtriangles].speculaire = SPECULAR;
          vobj_3d->face[numtriangles].shine = SHINE;
	  numtriangles++;
	}
      } else if (sscanf(buf, "%d/%d/%d", &v, &t, &n) == 3) {
	/* v/t/n */
	vobj_3d->face[numtriangles].pt1 = v-1;
        tmp_face_normal[numtriangles*3] = n-1;
	fscanf(file, "%d/%d/%d", &v, &t, &n);
	vobj_3d->face[numtriangles].pt2 = v-1;
        tmp_face_normal[numtriangles*3+1] = n-1;
	fscanf(file, "%d/%d/%d", &v, &t, &n);
	vobj_3d->face[numtriangles].pt3 = v-1;
        tmp_face_normal[numtriangles*3+2] = n-1;
	numtriangles++;
	while(fscanf(file, "%d/%d/%d", &v, &t, &n) > 0) {
	  vobj_3d->face[numtriangles].pt1 = vobj_3d->face[numtriangles-1].pt1;
          tmp_face_normal[numtriangles*3] = tmp_face_normal[(numtriangles-1)*3];
	  vobj_3d->face[numtriangles].pt2 = vobj_3d->face[numtriangles-1].pt3;
          tmp_face_normal[numtriangles*3] = tmp_face_normal[(numtriangles-1)*3+2];
	  vobj_3d->face[numtriangles].pt3 = v-1;
          tmp_face_normal[numtriangles*3+2] = n-1;
          /* fixe des proprites arbitraires */
          /* de rflexion de la lumire      */
          vobj_3d->face[numtriangles].diffuse = DIFFUSE;
          vobj_3d->face[numtriangles].speculaire = SPECULAR;
          vobj_3d->face[numtriangles].shine = SHINE;
	  numtriangles++;
	}
      } else if (sscanf(buf, "%d/%d", &v, &t) == 2) {
	/* v/t */
	vobj_3d->face[numtriangles].pt1 = v-1;
	fscanf(file, "%d/%d", &v, &t);
	vobj_3d->face[numtriangles].pt2 = v-1;
	fscanf(file, "%d/%d", &v, &t);
	vobj_3d->face[numtriangles].pt3 = v-1;
	numtriangles++;
	while(fscanf(file, "%d/%d", &v, &t) > 0) {
	  vobj_3d->face[numtriangles].pt1 = vobj_3d->face[numtriangles-1].pt1;
	  vobj_3d->face[numtriangles].pt2 = vobj_3d->face[numtriangles-1].pt3;
	  vobj_3d->face[numtriangles].pt3 = v;
          /* fixe des proprites arbitraires */
          /* de rflexion de la lumire      */
          vobj_3d->face[numtriangles].diffuse = DIFFUSE;
          vobj_3d->face[numtriangles].speculaire = SPECULAR;
          vobj_3d->face[numtriangles].shine = SHINE;
	  numtriangles++;
	}
      } else {
	/* v */
	sscanf(buf, "%d", &v);
	vobj_3d->face[numtriangles].pt1 = v-1;
	fscanf(file, "%d", &v);
	vobj_3d->face[numtriangles].pt2 = v-1;
	fscanf(file, "%d", &v);
	vobj_3d->face[numtriangles].pt3 = v-1;
	numtriangles++;
	while(fscanf(file, "%d", &v) > 0) {
	  vobj_3d->face[numtriangles].pt1 = vobj_3d->face[numtriangles-1].pt1;
	  vobj_3d->face[numtriangles].pt2 = vobj_3d->face[numtriangles-1].pt3;
	  vobj_3d->face[numtriangles].pt3 = v-1;
          /* fixe des proprites arbitraires */
          /* de rflexion de la lumire      */
          vobj_3d->face[numtriangles].diffuse = DIFFUSE;
          vobj_3d->face[numtriangles].speculaire = SPECULAR;
          vobj_3d->face[numtriangles].shine = SHINE;
	  numtriangles++;
	}
      }
      break;

    default:
      /* eat up rest of line */
      fgets(buf, sizeof(buf), file);
      break;
    }
  }
}
/***************************/

  /* on referme le fichier OBJ */
  fclose(fichier);

  if(nb_normal)
  {
    /* on alloue le tableau des normales aux sommets */
    if((vobj_3d->normal_dot = (dot_3d *)malloc(vobj_3d->nb_face*3*sizeof(dot_3d))) == NULL)
    { perror("malloc failed "); exit(1); }

    { uint32 i;
      for(i=0;i<vobj_3d->nb_face*3;i++)
      {
        vobj_3d->normal_dot[i] = tmp_normal[tmp_face_normal[i]];
      }
    }

    free(tmp_face_normal);
    free(tmp_normal);
  }

  return(vobj_3d);
}
/*************************************************/
