/****************************************************/
/* Bibliotheque qui charge des objets 3d a partir   */
/* de fichiers ASC                                  */
/* obj_3d_from_asc.c                                */
/*                                                  */
/* Ecrit par : Daniel Lacroix (all rights reserved) */
/*                                                  */
/****************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <obj_3d_from_asc.h>

/*******************************************************/
/* A FAIRE                                             */
/* - ne prend pas en compte les informations de smooth */
/* - ne supporte que les fichiers au format americain  */
/*******************************************************/

/*************************************************/
/* Renvoi l'objet 3d contenu dans le fichier ASC */
/* ou NULL si impossible                         */
obj_3d *obj_3d_new_from_asc(char *filename)
{ 
  obj_3d *vobj_3d;

  FILE *fichier;
  char tmp_str[120];
  char tmp_char;
  int  vertices, faces, count, vNum, tempA, tempB, tempC;

  /* alloue la memmoire pour la structure de base de l'objet 3D */
  if((vobj_3d = (obj_3d *)malloc(sizeof(obj_3d))) == NULL)
  { perror("malloc failed "); exit(1); }

  /* mode de rendu */
/*  vobj_3d->render_type = FLAT;*/
  vobj_3d->fill_mode = FLAT;
  /* numero d'identifiant de l'objet (utilise dans obj_buf) */
  vobj_3d->id      = 0;
  /* nombre de polygone de cet objet */
  vobj_3d->nb_face = 0;
  /* definition de tout les polygones */
  vobj_3d->face    = NULL;
  /* nombre de point de cet objet */
  vobj_3d->nb_dot  = 0;
  /* definition de tout les points (utilise dans les polygones) */
  vobj_3d->dot     = NULL;
  /* tampon pour les calculs des points de l'objet apres transformation */
  vobj_3d->dot_tmp = NULL;
  /* vecteur normaux (utilise dans les polygones) */
  vobj_3d->normal  = NULL;
  /* vecteur normaux en chaque sommet */
  vobj_3d->normal_dot = NULL;
  /* transformation a appliquer sur l'objet (null si aucune) */
  vobj_3d->obj_mat = NULL;

  /* ouverture du fichier ASC */
  if((fichier = fopen(filename, "r")) == NULL)
  { free(vobj_3d); return(NULL); }

  while(strncmp(tmp_str, "Vertices", 8))
  {
    fscanf(fichier, "%119s", tmp_str);
    if(feof(fichier))
    { 
      printf("End of file and string \"Vertex\" NOT FOUND!!\n");
      fclose(fichier); free(vobj_3d); return(NULL);
    }
  }

  /*printf("Found string: %s\n", tmp_str);*/

  tmp_char = fgetc(fichier);

  fscanf(fichier, "%d", &vertices);

  /*printf("Object has %d vertices\n", vertices);*/

  while(strncmp(tmp_str, "Faces", 5))
  {
    fscanf(fichier, "%119s", tmp_str);
    if(feof(fichier))
    {
      printf("End of file and string \"Faces\" NOT FOUND!!\n");
      fclose(fichier); free(vobj_3d); return(NULL);
    }
  }
  
  /*printf("Found string: %s\n", tmp_str);*/
  tmp_char = fgetc(fichier);

  fscanf(fichier, "%d", &faces);

  /*printf("Object has %d faces\n", faces);*/

  while(strncmp(tmp_str, "Vertex", 6))
  {
    fscanf(fichier, "%119s", tmp_str);
    if(feof(fichier))
    {
      printf("End of file and string \"Vertex\" NOT FOUND!!\n");
      fclose(fichier); free(vobj_3d); return(NULL);
    }
  }
  while(strncmp(tmp_str, "list:", 5))
  {
    fscanf(fichier, "%119s", tmp_str);
    if(feof(fichier))
    {
      printf("End of file and string \"list:\" NOT FOUND!!\n");
      fclose(fichier); free(vobj_3d); return(NULL);
    }
  }
  
  /* alloue la memoire pour les definitions de polygones */
  if((vobj_3d->face = (face *)malloc(faces*sizeof(face))) == NULL)
  { perror("malloc failed "); exit(1); }
    
  /* alloue la memoire pour le tableau des points */
  if((vobj_3d->dot = (dot_3d *)malloc(vertices*sizeof(dot_3d))) == NULL)
  { perror("malloc failed "); exit(1); }

  /*printf("\nVertex data:\n");*/

  tmp_str[0] = 6; tmp_str[1] = 6; tmp_str[2] = 6;
  
  /* rempli le tableau des points */
  for(count = 0; count < vertices; count++)
  {
    while(strncmp(tmp_str, "Vertex", 6))
    {
      fscanf(fichier, "%119s", tmp_str);
      if(feof(fichier))
      {
        printf("End of file and string \"Vertex\" NOT FOUND!!\n");
        fclose(fichier); free(vobj_3d->face); free(vobj_3d->dot);
	free(vobj_3d); return(NULL);
      }
    }

    fscanf(fichier, "%d", &vNum);
    if(vNum >= vertices)
    { 
      printf("Une definition de point incorrecte\n");
      fclose(fichier); free(vobj_3d->face); free(vobj_3d->dot);
      free(vobj_3d); return(NULL);
    }
    fscanf(fichier, "%119s", tmp_str);
    fscanf(fichier, "%119s", tmp_str);
    fscanf(fichier, "%f", &vobj_3d->dot[vNum].x);
    fscanf(fichier, "%119s", tmp_str);
    fscanf(fichier, "%f", &vobj_3d->dot[vNum].y);
    fscanf(fichier, "%119s", tmp_str);
    fscanf(fichier, "%f", &vobj_3d->dot[vNum].z);

    /*printf("Vertex %d:  %f %f %f\n", vNum,vobj_3d->dot[vNum].x,
      vobj_3d->dot[vNum].y, vobj_3d->dot[vNum].z);*/
  }

  while(strncmp(tmp_str, "Face", 4))
  {
    fscanf(fichier, "%119s", tmp_str);
    if(feof(fichier))
    {
      printf("End of file and string \"Face\" NOT FOUND!!\n");
      fclose(fichier); free(vobj_3d->face); free(vobj_3d->dot);
      free(vobj_3d); return(NULL);
    }
  }

  /*printf("\nFound string: %s\n", tmp_str);*/

  while(strncmp(tmp_str, "list", 4))
  {
    fscanf(fichier, "%119s", tmp_str);
    if(feof(fichier))
    {
      printf("End of file and string \"list\" NOT FOUND!!\n");
      fclose(fichier); free(vobj_3d->face); free(vobj_3d->dot);
      free(vobj_3d); return(NULL);
    }
  }

  /*printf("Found string: %s\n", tmp_str);

  printf("\nFacial data:\n");*/

  /* rempli le tableau avec les definitions des polygones (faces) */
  for(count = 0; count < faces; count++)
  {
    while(strncmp(tmp_str, "Face", 4))
    {
      fscanf(fichier, "%119s", tmp_str);
      if(feof(fichier))
      {
        printf("End of file and string \"Face\" NOT FOUND!!\n");
        fclose(fichier); free(vobj_3d->face); free(vobj_3d->dot);
        free(vobj_3d); return(NULL);
      }
    }

    fscanf(fichier, "%d", &vNum);      
    fscanf(fichier, "%119s", tmp_str);

    while(fgetc(fichier) != 'A');
    fgetc(fichier);                  /* get the ':' character   */
    fscanf(fichier, "%d", &tempA);   /* get value for vertex A  */

    while (fgetc(fichier) != 'B');
    fgetc(fichier);
    fscanf(fichier, "%d", &tempB);

    while (fgetc(fichier) != 'C');
    fgetc(fichier);
    fscanf(fichier, "%d", &tempC);

    if((vNum >= faces) || (tempA >= vertices) || 
       (tempB >= vertices) || (tempC >= vertices))
    {
      printf("Une face est mal definie\n");
      fclose(fichier); free(vobj_3d->face); free(vobj_3d->dot);
      free(vobj_3d); return(NULL);
    }

    /* l'ordre des faces est problmatique et je ne sais */
    /* pas comment le dterminer pour l'instant.         */
    vobj_3d->face[vNum].pt1 = tempA;
    vobj_3d->face[vNum].pt2 = tempB;
    vobj_3d->face[vNum].pt3 = tempC;

    /* fixe des proprites arbitraires */
    /* de rflexion de la lumire      */
    vobj_3d->face[vNum].diffuse = 0.6;
    vobj_3d->face[vNum].speculaire = 0.5;
    vobj_3d->face[vNum].shine = 20.0;

    /*printf("Face %d:  %8d %8d %8d\n", vNum, vobj_3d->face[vNum].pt1,
      vobj_3d->face[vNum].pt2, vobj_3d->face[vNum].pt3);*/

    /* choisi une couleur arbitraire pour la face */
/*    vobj_3d->face[vNum].col1.r = 255;
    vobj_3d->face[vNum].col1.g = 0;
    vobj_3d->face[vNum].col1.b = 0;*/

  }

  vobj_3d->nb_face = faces;
  vobj_3d->nb_dot  = vertices;
  
  /* on referme le fichier ASC */
  fclose(fichier);

  return(vobj_3d);
}
/*************************************************/
