/****************************************************/
/* Bibliothque qui charge des objets 3d  partir   */
/* de fichiers 3DS                                  */
/* obj_3d_from_3ds.c                                */
/*                                                  */
/* Ecrit par : Daniel Lacroix (all rights reserved) */
/*                                                  */
/****************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <obj_3d_from_3ds.h>

#include <lib3ds/file.h>
#include <lib3ds/vector.h>
#include <lib3ds/matrix.h>
#include <lib3ds/camera.h>
#include <lib3ds/light.h>
#include <lib3ds/material.h>
#include <lib3ds/mesh.h>
#include <lib3ds/node.h>

#define DIFFUSE  0.4
#define SPECULAR 0.6
#define SHINE    20.0

/*************************************************/
/* Renvoi l'objet 3d contenu dans le fichier 3DS */
/* ou NULL si impossible                         */
obj_3d *obj_3d_new_from_3ds(char *filename)
{
  Lib3dsFile *f = NULL;
  Lib3dsMesh *m;
  int i;
  int points = 0;
  int faces  = 0;
  obj_3d *vobj_3d = NULL;

  /* alloue la memoire pour la structure de base de l'objet 3D */
  if((vobj_3d = (obj_3d *)malloc(sizeof(obj_3d))) == NULL)
  { perror("malloc failed "); exit(1); }

  /* mode de rendu */
  vobj_3d->fill_mode = FLAT;
  /* numero d'identifiant de l'objet (utilise dans obj_buf) */
  vobj_3d->id      = 0;
  /* nombre de polygone de cet objet */
  vobj_3d->nb_face = 0;
  /* definition de tout les polygones */
  vobj_3d->face    = NULL;
  /* nombre de point de cet objet */
  vobj_3d->nb_dot  = 0;
  /* definition de tout les points (utilise dans les polygones) */
  vobj_3d->dot     = NULL;
  /* tampon pour les calculs des points de l'objet apres transformation */
  vobj_3d->dot_tmp = NULL;
  /* vecteur normaux (utilise dans les polygones) */
  vobj_3d->normal  = NULL;
  /* vecteur normaux en chaque sommet */
  vobj_3d->normal_dot = NULL;
  /* transformation a appliquer sur l'objet (null si aucune) */
  vobj_3d->obj_mat = NULL;

  f = lib3ds_file_load(filename);
  if(f == NULL) goto error;

  for (m=f->meshes; m; m=m->next) {
    points += m->points;
    faces  += m->faces;
  }
    
  vobj_3d->nb_dot  = points;
  vobj_3d->nb_face = faces;

  points = 0;
  faces  = 0;

  /* alloue la mmoire pour les points */
  if((vobj_3d->dot = (dot_3d *)malloc(vobj_3d->nb_dot*sizeof(dot_3d))) == NULL)
  { perror("malloc failed "); exit(1); }

  /* alloue la mmoire pour les faces */
  if((vobj_3d->face = (face *)malloc(vobj_3d->nb_face*sizeof(face))) == NULL)
  { perror("malloc failed "); exit(1); }

  for (m=f->meshes; m; m=m->next) {

    for(i=0;i<m->points;i++)
    {
      vobj_3d->dot[points+i].x = m->pointL[i].pos[0];
      vobj_3d->dot[points+i].y = m->pointL[i].pos[1];
      vobj_3d->dot[points+i].z = m->pointL[i].pos[2];
    }

    for(i=0;i<m->faces;i++)
    {
      vobj_3d->face[faces+i].pt1 = points+m->faceL[i].points[0];
      vobj_3d->face[faces+i].pt2 = points+m->faceL[i].points[1];
      vobj_3d->face[faces+i].pt3 = points+m->faceL[i].points[2];
      /* fixe des proprites arbitraires */
      /* de rflexion de la lumire      */
      vobj_3d->face[faces+i].diffuse    = DIFFUSE;
      vobj_3d->face[faces+i].speculaire = SPECULAR;
      vobj_3d->face[faces+i].shine      = SHINE;  
    }
    points += m->points;
    faces  += m->faces;
  }
    
  lib3ds_file_free(f);
  return(vobj_3d);
  
error:
  if(vobj_3d)
  {
    if(vobj_3d->face)
      free(vobj_3d->face);
    if(vobj_3d->dot)
      free(vobj_3d->dot);
    if(vobj_3d->dot_tmp)
      free(vobj_3d->dot_tmp);
    if(vobj_3d->normal)
      free(vobj_3d->normal);
    if(vobj_3d->normal_dot)
      free(vobj_3d->normal_dot);
    if(vobj_3d->obj_mat)
      free(vobj_3d->obj_mat);
    free(vobj_3d);
  }
  if(f)
    lib3ds_file_free(f);
  return(NULL);
}
/*************************************************/
