/**********************************************************************/
/* Bibliotheque de filtrage d'images au format TrueColor 32bitd       */
/* image_filter.h                                                     */
/*                                                                    */
/* Ecrit par : Daniel Lacroix (all rights reserved)                   */
/*                                                                    */
/**********************************************************************/

#ifndef __IMAGE_FILTER_H__
#define __IMAGE_FILTER_H__

#include <general.h>
#include <image.h>

/* Fait un flou gaussien de l'image psrc et place le resultat */
/* dans pdest. pdest et psrc doivent avoir la mme taille.    */
void image_blur(image *pdest, image *psrc);

/* Ce filtre est un filtre qui preserve les contours en       */
/* s'adaptant aux drive des points autour du point en       */
/* traitement. pdest et psrc doivent avoir la mme taille.    */
void image_edge_protect(image *pdest, image *psrc);

/* Applique un filtre mdian sur l'image psrc et place le resultat */
/* dans pdest. pdest et psrc doivent avoir la mme taille.         */
void image_median(image *pdest, image *psrc);

/* Ce filtre est un filtre de Blur qui preserve les contours en     */
/* utilisant le calcul de drives de Sobel. Si il s'agit d'un      */
/* contour, on conserve le point d'origine proportionnellement  la */
/* drive. pdest et psrc doivent avoir la mme taille.             */
void image_blur_edge_protect(image *pdest, image *psrc);

/* Calcul la drive x,y en chaque points  l'aide du   */
/* filtre de Sobel. La driv est calcul pour chaque   */
/* couleur. C'est la norme du gradient qui est utilise */
/* pour dterminer le niveau de chaque couleur dans     */
/* l'image destination. psrc est l'image d'origine et   */
/* pdest est l'image destination. psrc et pdest doivent */
/* avoir la mme taille.                                */
void image_sobel(image *pdest, image *psrc);

/* Fait une dtection de contours. Le rsultat est une      */
/* image noir ou blanc o les points blancs correspondent   */
/* aux points appartenant  un contour. Pour avoir de       */
/* bon rsultat, il est conseill de passer l'image         */
/* d'origine dans un filtre de flou (par exemple gaussien). */
/* psrc est l'image d'origine et pdest est l'image          */
/* destination. psrc et pdest doivent avoir la mme taille. */
void image_edge_max(image *pdest, image *psrc);

/* On calcule l'histogramme de l'image pimage */
/* L'histogramme est un histogramme 2D avec   */
/* rouge/intensit normalise en x            */
/*  vert/intensit normalise en y            */
/* en (u,v) on trouve la probabilit (0  1)  */
/* d'apparition de la couleur. Le tableau     */
/* retourn doit tre dallou avec free.     */
float *histo_real(image *pimage);

/* Retourne une image qui correspond aux probas que chaque            */
/* point de l'image pimage appartienne  l'histogramme hist_pattern   */
/* En d'autre terme, si hist_pattern correspond  l'histogramme       */
/* d'une texture, la proba indique si un point dans pimage correspond */
/* ou pas  ce type de texture. Le barycentre des probas est          */
/* reprsent par une croix rouge. Un rectangle autour du barycentre  */
/* indique la zone comprise dans l'cart type du barycentre (zone     */
/* dtect). L'image retourne doit tre libre avec image_free      */
image *find_histo(image *pimage, float *hist_pattern);

/* Egalize l'histogramme de l'intensit de la lumire pour           */
/* l'image psrc. Cela veut dire que l'image pdest comporte           */
/* autant de point pour chaque intensit de lumire aprs traitement */
void image_equalize(image *pdest, image *psrc);

/* Calcul le laplacien en chaque points. Le laplacien   */
/* est calcul pour chaque couleur. psrc est l'image    */
/* d'origine et pdest est l'image destination. psrc et  */
/* pdest doivent avoir la mme taille.                  */
void image_laplacien(image *pdest, image *psrc);

void image_laplacien_edge(image *pdest, image *psrc);

#endif /* __IMAGE_FILTER_H__ */
