#ifndef lint
static char RCSid[] = 
"$Id: table.c,v 1.8 1995/10/17 19:59:12 mcooper Exp $";

static char copyright[] =
"@(#) Copyright (c) 1990-1995 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1995 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

#include "config.h"

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "qterm.h"

/*
 * Add termtab (n) entry to main termtab.
 */
int AddTerm(termtable)
    struct termtable 	       *termtable;
{
    register struct termtable  *tp;
    extern struct termtable    *TermTable;
    
    if (!termtable)
	return(-1);
    
    termtable->nxt = NULL;
    
    if (TermTable == NULL)
	TermTable = termtable;
    else {
	tp = TermTable;
	while(tp && tp->nxt)
	  tp = tp->nxt;
	tp->nxt = termtable;
    }
    
    return(0);
}
/*
 * Make a string readable
 */
char *FixCntrl(str, rex)
    char 		       *str;
    int 			rex;
{
    register int 		i;
    static char 		buf[BUFSIZ];
    
    for (i = 0; str && *str; ) {
	switch (*str) {
	case '\\':
	    if (isdigit(*++str)) {
		buf[i] = 0;
		while (isdigit(*str))
		    buf[i] = (char) (((int)buf[i] * 8) + 
				     (int)*str++ - (int) '0');
		i++;
	    } else
		buf[i++] = *str++;
	    continue;
	    
	case '^':
	    switch (*++str) {
	    case '?':
		buf[i++] = '\177';
		break;
	    default:
		buf[i++] = *str & 037;
		break;
	    }
	    break;
	    
	    /* Special R.E. symbols */
	case '[':
	case '*':
	case '.':
	case '$':
	case '{':
	case '(':
	    if (rex)
		buf[i++] = '\\';
	    
	  default:
	    buf[i++] = *str;
	}
	++str;
    }
    
    buf[i] = (char) NULL;
    
    return(buf);
}

/*
 * Make a termtab table
 */
void MakeTable()
{
    char 			file[MAXPATHLEN];
    struct passwd 	       *pwd;
    struct passwd 	       *getpwuid();
    char 		       *home;

    dprintf("[ initilizing term table... ]\n");
    
    if (TermFile != NULL)
	(void) ReadTabFile(TermFile, FALSE);

    if (DoUsrTabFile) {
	/*
	 * Try to read the user's own table
	 */
	if ((home = getenv("HOME")) == NULL) {
	    if ((pwd = getpwuid(getuid())) == NULL) {
		Error("Cannot find password entry for uid %d.", getuid());
		Done(1);
		/*NOTREACHED*/
	    }
	    home = pwd->pw_dir;
	}

	(void) sprintf(file, "%s/%s", home, USRFILE);
	if (ReadTabFile(file, TRUE) < 0) {
	    (void) sprintf(file, "%s/%s", home, OLDUSRFILE);
	    (void) ReadTabFile(file, TRUE);
	}
    }
    
    if (DoSysTabFile)
	(void) ReadTabFile(TABFILE, FALSE);
    
    dprintf("[ MakeTable done ]\n");
}

/*
 * Read a qtermtab file
 */
int ReadTabFile(file, bequiet)
    char 		       *file;
    int 			bequiet;
{
    static char		        fields[6][BUFSIZ];
    register int		line = 0;
    static char			buf[BUFSIZ];
    char		       *errmsg;
    FILE 		       *fd;
    struct termtable 	       *tp;
    int				etype;
    
    if ((fd = fopen(file, "r")) == NULL) {
	if (bequiet) {
	    dprintf("[ tab file '%s' can not read: %s ]\n", file, SYSERR);
	    return(-1);
	}
	Error("Cannot open file for reading: %s: %s.", file, SYSERR);
	Done(1);
	/*NOTREACHED*/
    }

    dprintf("[ Read tab file '%s' ]\n", file);

    while (fgets(buf, sizeof(buf), fd)) {
	++line;
	
	if (buf[0] == '#' || buf[0] == '\n')
	    continue;

	fields[0][0] = fields[1][0] = fields[2][0] = 
	    fields[3][0] = fields[4][0] = fields[5][0] = (char)NULL;

	/*
	 * Read the first field and use it to figure out what type
	 * of entry this is.
	 */
	(void) sscanf(buf, "%s", fields[0]);
	if (strncasecmp(buf, K_PRIMARY, 3) == 0)
	    etype = ET_PRIMARY;
	else if (strncasecmp(buf, K_SECONDARY, 3) == 0)
	    etype = ET_SECONDARY;
	else if (strncasecmp(buf, K_COMSEQ, 3) == 0) {
	    extern char	      **CommonSeqs;
	    register char     **cpp;
	    static char	      **argv = NULL;
	    register int	argc, i;

	    if ((argc = StrToArgs(buf, &argv, " \t")) > 1) {
		CommonSeqs = (char **) xmalloc(sizeof(char *) * (argc + 1));
		for (cpp = argv + 1, i = 0; cpp && *cpp; ++cpp) {
		    CommonSeqs[i++] = StrCopy(*cpp);
		    CommonSeqs[i] = (char *)NULL;
		}
	    }
	    continue;
	} else if (buf[0])	/* Must be an old style entry */
	    etype = ET_OLDSTYLE;
	else			/* Must be a blank line */
	    continue;

	/*
	 * Read the whole line based on the entry type
	 */
	switch (etype) {
	case ET_PRIMARY:
	case ET_SECONDARY:
	    (void) sscanf(buf, "%s%s%s%s%s\t%[^\n]", 
			  fields[0], fields[1], fields[2], 
			  fields[3], fields[4], fields[5]);
	    break;
	case ET_OLDSTYLE:
	    (void) sscanf(buf, "%s%s%s\t%[^\n]", 
			  fields[1], fields[2], fields[3], fields[5]);
	    break;
	}

	errmsg = NULL;
	if (fields[1][0] == (char) NULL)
	    errmsg = "send string";
	if (fields[2][0] == (char) NULL)
	    errmsg = "receive string";
	if (fields[3][0] == (char) NULL)
	    errmsg = "generic terminal name";
	if (etype == ET_PRIMARY || etype == ET_SECONDARY)
	    if (fields[4][0] == (char) NULL)
		errmsg = "next terminal name";
	if (errmsg) {
	    Error("Line %d of %s: Error parsing %s.", line, file, errmsg);
	    Done(1);
	    /*NOTREACHED*/
	}

	tp = (struct termtable *) xmalloc(sizeof(struct termtable));

	tp->qt_etype = etype;
	tp->qt_sendstr = StrCopy(FixCntrl((UseAltStr) ? 
					  ALTSEND : fields[1], 0));
	tp->qt_recvstr = StrCopy(FixCntrl(fields[2], 1));
	tp->qt_termname = StrCopy(fields[3]);
	if (fields[4][0])
	    tp->qt_ntermname = StrCopy(fields[4]);
	else
	    tp->qt_ntermname = tp->qt_termname;
	tp->qt_fullname = StrCopy(fields[5]);

	dprintf("\n   Entry Type = %d\n", tp->qt_etype);
	dprintf("  Send String = %s\n", Decode(tp->qt_sendstr));
	dprintf("Expect String = %s\n", Decode(tp->qt_recvstr));
	dprintf("Terminal Name = '%s'\n", tp->qt_termname);
	dprintf("    Next Name = '%s'\n", tp->qt_ntermname);
	dprintf("    Full Name = '%s'\n", 
		(tp->qt_fullname) ? tp->qt_fullname : "<none>");
	
	(void) AddTerm(tp);
    }
    
    return(0);
}

