#ifndef lint
static char RCSid[] = 
"$Id: signals.c,v 6.4 1997/04/11 13:13:27 agc Exp agc $";

static char copyright[] =
"@(#) Copyright (c) 1990-1995 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1995 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

#include "config.h"
#include "qterm.h"
#include <stdio.h>
#include <signal.h>

#ifdef HAVE_SIGACTION
void SetupSignals(func)
    void		       (*func)();
{
    struct sigaction		act;

    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    act.sa_handler = func;

    (void) sigaction(SIGINT, &act, (struct sigaction *)NULL);
    (void) sigaction(SIGHUP, &act, (struct sigaction *)NULL);
    (void) sigaction(SIGTERM, &act, (struct sigaction *)NULL);
}
#else
void SetupSignals(func)
    void		       (*func)();
{
    (void) signal(SIGINT, func);
    (void) signal(SIGHUP, func);
    (void) signal(SIGTERM, func);
}
#endif /* HAVE_SIGACTION */

/*
 * Turn off alarm
 */
void AlarmOff()
{
    (void) alarm((unsigned) 0);
}

#ifdef HAVE_SIGACTION
/*
 * POSIX turn on alarm
 */
void AlarmOn(timeout, func)
    int				timeout;
    void		       (*func)();
{
    struct sigaction		act;

    AlarmOff();

    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    act.sa_handler = func;
    if (sigaction(SIGALRM, &act, (struct sigaction *)NULL) != 0)
	Error("sigaction failed to set SIGALRM: %s.", SYSERR);

    (void) alarm(timeout);
}
#else
/*
 * Unix turn on alarm
 */
void AlarmOn(timeout, func)
    int				timeout;
    void		      (*func)();
{
    AlarmOff();

    (void) signal(SIGALRM, func);
    (void) alarm(timeout);
}
#endif /* HAVE_SIGACTION */
