#ifndef lint
static char RCSid[] = 
"$Id: aux.c,v 6.8 1997/04/11 13:13:27 agc Exp agc $";

static char copyright[] =
"@(#) Copyright (c) 1990-1995 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1995 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

#include "config.h"
#include "qterm.h"

#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#else
#ifdef HAVE_VARARGS_H
#include <stdarg.h>
#endif /* HAVE_VARARGS_H */
#endif /* HAVE_STDARG_H */


/*
 * Get system error string
 */
char *SysErr()
{
#ifdef HAVE_STRERROR
	extern int	errno;

	return strerror(errno);
#else
    extern int			errno;
    extern int			sys_nerr;
    extern char		       *sys_errlist[];
    static char			buff[BUFSIZ];

    if (errno > 0 && errno < sys_nerr)
	return(sys_errlist[errno]);
    else {
	(void) sprintf(buff, "Unknown error %d", errno);
	return(buff);
    }
#endif
}

#ifdef HAVE_STDARG_H
/*
 * Stdargs Error()
 */
void Error(char *fmt, ...)
{
    va_list 			args;

    (void) fprintf(stderr, "%s: ", ProgName);

    va_start(args, fmt);
    if (fmt)
	(void) vfprintf(stderr, fmt, args);
    va_end(args);

    (void) fprintf(stderr, "\r\n");
}
#else
#ifdef HAVE_VARARGS_H
/*
 * Varargs Error()
 */
void Error(va_alist)
    va_dcl
{
    va_list 			args;
    char		       *fmt;

    (void) fprintf(stderr, "%s: ", ProgName);

    va_start(args);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);
    va_end(args);

    (void) fprintf(stderr, "\r\n");
}
#else
/*
 * Simple Error()
 */
void Error(fmt, a1, a2, a3, a4, a5, a6)
    char *fmt;
{
    (void) fprintf(stderr, "%s: ", ProgName);

    if (fmt)
	(void) fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);

    (void) fprintf(stderr, "\r\n");
}
#endif /* HAVE_VARARGS_H */
#endif /* HAVE_STDARG_H */


#ifdef HAVE_STDARG_H
/*
 * Stdargs dprintf()
 */
void dprintf(char *fmt, ...)
{
    va_list 			args;

    if (!Debug)
	return;

    va_start(args, fmt);
    if (fmt)
	(void) vfprintf(stderr, fmt, args);
    va_end(args);
}
#else
#ifdef HAVE_VARARGS_H
/*
 * Varargs dprintf()
 */
void dprintf(va_alist)
    va_dcl
{
    va_list 			args;
    char		       *fmt;

    if (!Debug)
	return;

    va_start(args);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);
    va_end(args);
}
#else
/*
 * Simple dprintf()
 */
void dprintf(fmt, a1, a2, a3, a4, a5, a6)
    char *fmt;
{
    if (!Debug)
	return;

    if (fmt)
	(void) fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
}
#endif /* HAVE_VARARGS_H */
#endif /* HAVE_STDARG_H */


/*
 * xmalloc - Do a malloc with error checking.
 */
char *xmalloc(size)
    int 			size;
{
    char 		       *p;
    
    if ((p = (char *) malloc((unsigned) size)) == (char *) NULL) {
	Error("malloc %d bytes failed: %s.", size, SYSERR);
	Done(1);
	/*NOTREACHED*/
    }
    
    return(p);
}

#ifdef HAVE_REGCMP
/*
 * SYSV style regular expression matching
 */
int RegExMatch(re, string)
    char		       *re;
    char		       *string;
{
    char		       *reptr;
    char		       *regcmp();
    int				status = 0;

    if ((reptr = regcmp(re, (char *)NULL)) == (char *)NULL) {
	Error("Bad regular expression: \"%s\".", re);
	return(-1);
    }

    if (regex(reptr, string))
	status = 1;	/* Matched */

    (void) free(reptr);
    return(status);
}
#else
#ifdef HAVE_REGCOMP
/*
 * HP/UX style regular expression matching
 */
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif

int RegExMatch(pattern, string)
    char		       *pattern;
    char		       *string;
{
    int				status = 0;
    regex_t			re;
    int				n;

    if ((n = regcomp(&re, pattern, REG_NOSUB|REG_NEWLINE)) != 0) {
	Error("Bad regular expression: \"%s\" (%d).", pattern, n);
	return(-1);
    }

#ifdef HAVE_REGEXEC
    if (regexec(&re, string, (size_t) 0, NULL, 0) == 0)
#else
    if (regex(&re, string, (size_t) 0, NULL, 0) == 0)
#endif /* !HAVE_REGEXEC */
	status = 1;	/* Matched */

    regfree(&re);
    return(status);
}
#else
/*
 * BSD style regular expression matching
 */
int RegExMatch(re, string)
    char		       *re;
    char		       *string;
{
    char		       *errmsg;
    char		       *re_comp();

    if (errmsg = re_comp(re)) {
	Error("Bad regular expression: \"%s\": %s.", re, errmsg);
	return(-1);
    }

    if (re_exec(string) == 1)
	return(TRUE);	/* Matched */

    return(0);
}
#endif /* HAVE_REGCOMP */
#endif /* HAVE_REGCMP */

/*
 * Copy a string
 */
char *StrCopy(ptr)
    char		       *ptr;
{
    char		       *newptr;

    if (!ptr)
	return((char *)NULL);

    newptr = xmalloc(strlen(ptr)+1);
    (void) strcpy(newptr, ptr);

    return(newptr);
}

#ifndef HAVE_STRNCASECMP
int
strncasecmp(char *s1, char *s2, int len)
{
	int	c;

	for ( ; len-- > 0 ; s1++, s2++) {
		if ((c = tolower(*s1) - tolower(*s2)) != 0) {
			return c;
		}
	}
	return 0;
}
#endif
